/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.ejbHelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import jeus.ejb.util.MethodConvertor;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.JavaTypeType;
import jeus.xml.binding.j2ee.MethodParamsType;
import jeus.xml.binding.j2ee.QueryMethodType;
import jeus.xml.binding.j2ee.QueryType;
import jeus.xml.binding.jeusDD.FindMethodType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.MethodParamType;

public class FindMethodPair {
    private String methodSignature;
    private QueryType queryType;
    private FindMethodType findMethodType;
    private String methodName;
    private ArrayList paramList;

    public FindMethodPair(String methodSignature, QueryType queryType, FindMethodType findMethodType, boolean defaultIncludeUpdate) {
        this.methodSignature = methodSignature;
        StringTokenizer tokenizer = new StringTokenizer(methodSignature);
        this.methodName = tokenizer.nextToken();
        this.paramList = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            this.paramList.add(tokenizer.nextToken());
        }
        this.queryType = queryType;
        if (findMethodType == null) {
            findMethodType = ObjectFactoryHelper.getJeusDDObjectFactory().createFindMethodType();
            findMethodType.setIncludeUpdates(Boolean.valueOf(defaultIncludeUpdate));
        } else if (!findMethodType.isSetIncludeUpdates()) {
            findMethodType.setIncludeUpdates(Boolean.valueOf(defaultIncludeUpdate));
        }
        this.findMethodType = findMethodType;
    }

    public static ArrayList createFindMethodPairList(EntityBeanType entityBean, JeusBeanType jeusBean) throws EJBDescriptorValidationException, JAXBException {
        HashMap methodMap = new HashMap();
        List queryList = entityBean.getQuery();
        FindMethodPair.getEJBQueryMethods(queryList, methodMap);
        HashSet removedMethodSignature = new HashSet();
        ArrayList<FindMethodPair> findMethodPairList = new ArrayList<FindMethodPair>();
        boolean defaultIncludeUpdate = jeusBean.getPersistenceOptimize().isIncludeUpdate();
        List jeusQueryList = jeusBean.getSchemaInfo().getJeusQuery();
        FindMethodPair.addFindMethodInfo(jeusQueryList, removedMethodSignature, methodMap, findMethodPairList, defaultIncludeUpdate);
        List findMethodList = jeusBean.getSchemaInfo().getFindMethod();
        FindMethodPair.addFindMethodInfo(findMethodList, removedMethodSignature, methodMap, findMethodPairList, defaultIncludeUpdate);
        for (String methodSignature : methodMap.keySet()) {
            QueryType queryType = (QueryType)methodMap.get(methodSignature);
            findMethodPairList.add(new FindMethodPair(methodSignature, queryType, null, defaultIncludeUpdate));
        }
        return findMethodPairList;
    }

    private static void getEJBQueryMethods(List queryList, HashMap methodMap) {
        for (int i = 0; i < queryList.size(); ++i) {
            QueryType queryType = (QueryType)queryList.get(i);
            QueryMethodType queryMethodType = queryType.getQueryMethod();
            String methodName = queryMethodType.getMethodName().getValue();
            MethodParamsType paramType = queryMethodType.getMethodParams();
            List paramList = paramType.getMethodParam();
            ArrayList<String> stringParamList = new ArrayList<String>();
            for (int j = 0; j < paramList.size(); ++j) {
                JavaTypeType javaTypeType = (JavaTypeType)paramList.get(j);
                stringParamList.add(javaTypeType.getValue());
            }
            String methodSignature = MethodConvertor.getMethodParamToken(methodName, stringParamList);
            methodMap.put(methodSignature, queryType);
        }
    }

    private static void addFindMethodInfo(List findMethodList, HashSet removedMethodSignature, HashMap methodMap, ArrayList findMethodPairList, boolean defaultIncludeUpdate) throws EJBDescriptorValidationException, JAXBException {
        for (int i = 0; i < findMethodList.size(); ++i) {
            FindMethodType findMethodType = (FindMethodType)findMethodList.get(i);
            MethodParamType queryMethodType = findMethodType.getQueryMethod();
            String methodName = queryMethodType.getMethodName();
            jeus.xml.binding.jeusDD.MethodParamsType paramType = queryMethodType.getMethodParams();
            ArrayList paramList = paramType != null ? paramType.getMethodParam() : new ArrayList();
            ArrayList<String> stringParamList = new ArrayList<String>();
            for (int j = 0; j < paramList.size(); ++j) {
                String javaTypeType = (String)paramList.get(j);
                stringParamList.add(javaTypeType);
            }
            String methodSignature = MethodConvertor.getMethodParamToken(methodName, stringParamList);
            if (removedMethodSignature.contains(methodSignature)) {
                throw new EJBDescriptorValidationException("the method " + methodSignature + " is described in the jeus-ejb-dd.xml again");
            }
            QueryType queryType = (QueryType)methodMap.get(methodSignature);
            if (queryType != null) {
                findMethodPairList.add(new FindMethodPair(methodSignature, queryType, findMethodType, defaultIncludeUpdate));
            } else {
                findMethodPairList.add(new FindMethodPair(methodSignature, null, findMethodType, defaultIncludeUpdate));
            }
            methodMap.remove(methodSignature);
            removedMethodSignature.add(methodSignature);
        }
    }

    public String getMethod() {
        return this.methodSignature;
    }

    public boolean isIncludeUpdates() {
        return this.findMethodType.isIncludeUpdates();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ArrayList getMethodParams() {
        return this.paramList;
    }

    public String getSql() throws EJBDescriptorValidationException {
        String sql = this.findMethodType.getSql();
        if (sql != null) {
            return sql;
        }
        if (this.queryType != null) {
            return this.queryType.getEjbQl().getValue().trim();
        }
        return null;
    }
}

