/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.webservicesHelper;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.WebservicesDeploymentDescriptorFile;
import jeus.deploy.io.runtime.WebservicesRuntimeDDFile;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.j2ee.EjbLinkType;
import jeus.xml.binding.j2ee.PortComponentType;
import jeus.xml.binding.j2ee.ServiceImplBeanType;
import jeus.xml.binding.j2ee.ServletLinkType;
import jeus.xml.binding.j2ee.ServletMappingType;
import jeus.xml.binding.j2ee.ServletType;
import jeus.xml.binding.j2ee.UrlPatternType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.j2ee.WebserviceDescriptionType;
import jeus.xml.binding.j2ee.WebservicesType;
import jeus.xml.binding.jeusDD.JeusWebservicesDdType;
import jeus.xml.binding.jeusDD.PortType;
import jeus.xml.binding.jeusDD.ServiceType;
import jeus.xml.binding.jeusDD.WsdlPublishType;
import jeus.xml.binding.webservicesHelper.JeusWebservicesDDBindingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebservicesPair {
    private WebservicesType stdDD;
    private JeusWebservicesDdType extDD;
    private HashMap<String, PortType> url2PortComponentType = new HashMap();
    private HashMap<String, String> pcName2UrlMap = new HashMap();
    private HashMap<String, String> servletNameToUrlMap = new HashMap();
    private WebAppType webApp;
    private String context;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.xml.binding.webservicesHelper");

    public WebservicesPair(WebservicesType std, JeusWebservicesDdType ext) {
        this.stdDD = std;
        this.extDD = ext;
        this.init();
    }

    public WebservicesPair(WebservicesType std, JeusWebservicesDdType ext, WebAppType webApp) {
        this.stdDD = std;
        this.extDD = ext;
        this.webApp = webApp;
        this.init();
    }

    private void init() {
        if (this.stdDD != null && this.extDD != null) {
            for (WebserviceDescriptionType webservicesDescription : this.stdDD.getWebserviceDescription()) {
                for (PortComponentType portComponent : webservicesDescription.getPortComponent()) {
                    String pcName;
                    PortType portCompDD = JeusWebservicesDDBindingHelper.getPort(this.extDD, portComponent.getPortComponentName().getValue());
                    if (portCompDD == null) {
                        String portCompName = portComponent.getPortComponentName().getValue();
                        throw new RuntimeException("Mismatched <port-component-name> : " + portCompName + ". The <port-component-name> of 'jeus-webservices-dd.xml' must match the <port-component-name> of 'webservice.xml'");
                    }
                    String endpointUrl = null;
                    ServiceImplBeanType serviceImplBean = portComponent.getServiceImplBean();
                    if (serviceImplBean.getEjbLink() != null) {
                        endpointUrl = portCompDD.getEjbEndpointUrl();
                    } else {
                        ServletLinkType servletLink = serviceImplBean.getServletLink();
                        if (this.webApp != null) {
                            for (JAXBElement element : this.webApp.getDescriptionAndDisplayNameAndIcon()) {
                                Object obj = element.getValue();
                                if (!(obj instanceof ServletType)) continue;
                                ServletType servlet = (ServletType)obj;
                                String portServletName = servlet.getServletName().getValue();
                                if (!servletLink.getValue().equals(portServletName)) continue;
                                ServletMappingType servletMapping = WebservicesPair.getServletMapping(this.webApp, portServletName);
                                List urlPattern = servletMapping.getUrlPattern();
                                endpointUrl = ((UrlPatternType)urlPattern.get(0)).getValue();
                                this.servletNameToUrlMap.put(portServletName, endpointUrl);
                            }
                        }
                    }
                    if (endpointUrl == null) continue;
                    if (this.url2PortComponentType.get(endpointUrl) == null) {
                        this.url2PortComponentType.put(endpointUrl, portCompDD);
                    } else {
                        logger.finer("One <endpoint-url> is associated with several services. endpoint-url = [" + endpointUrl + "]");
                    }
                    if (this.pcName2UrlMap.get(pcName = portCompDD.getPortComponentName()) != null) continue;
                    this.pcName2UrlMap.put(pcName, endpointUrl);
                }
            }
            String ejbContextPath = this.extDD.getEjbContextPath();
            if (ejbContextPath != null) {
                this.context = ejbContextPath;
            }
        }
    }

    public List getHandlers(String pcName) {
        PortComponentType pc = this.getPortComponent(pcName);
        if (pc != null) {
            return pc.getHandler();
        }
        return null;
    }

    public WebserviceDescriptionType getWebserviceDescription(String wsDescName) {
        List descs = this.stdDD.getWebserviceDescription();
        for (WebserviceDescriptionType desc : descs) {
            String descName = desc.getWebserviceDescriptionName().getValue();
            if (!descName.equals(wsDescName)) continue;
            return desc;
        }
        return null;
    }

    public PortComponentType getPortComponent(String pcName) {
        List descs = this.stdDD.getWebserviceDescription();
        for (WebserviceDescriptionType desc : descs) {
            List pcs = desc.getPortComponent();
            for (PortComponentType pc : pcs) {
                String name = pc.getPortComponentName().getValue();
                if (!name.equals(pcName)) continue;
                return pc;
            }
        }
        return null;
    }

    public JeusWebservicesDdType getExtDD() {
        return this.extDD;
    }

    public WebservicesType getStdDD() {
        return this.stdDD;
    }

    public Set<String> getEndpoints() {
        return this.url2PortComponentType.keySet();
    }

    public PortType getServiceByEndpointURL(String endpointURL) {
        return this.url2PortComponentType.get(endpointURL);
    }

    public WsdlPublishType getWsdlPublish(String descName) {
        ServiceType serviceDD = JeusWebservicesDDBindingHelper.getService(this.extDD, descName);
        if (serviceDD == null) {
            return null;
        }
        WsdlPublishType wsdlPublish = serviceDD.getWsdlPublish();
        return wsdlPublish;
    }

    public String getWsdlFile(String descName) {
        WebserviceDescriptionType wsDesc = this.getWebserviceDescription(descName);
        if (wsDesc == null) {
            return null;
        }
        return wsDesc.getWsdlFile().getValue();
    }

    public String getEndpointURLByPortComponentName(String pcName) {
        return this.pcName2UrlMap.get(pcName);
    }

    public String getEndpointUrlByServletName(String servletName) {
        return this.servletNameToUrlMap.get(servletName);
    }

    public static WebservicesPair makeNewPair(String infDir, AbstractArchive archive) throws IOException, JAXBException {
        WebservicesPair pair;
        WebservicesType stdDD = (WebservicesType)new WebservicesDeploymentDescriptorFile(infDir).getDeploymentDescriptor(archive);
        JeusWebservicesDdType extDD = (JeusWebservicesDdType)new WebservicesRuntimeDDFile(infDir).getDeploymentDescriptor(archive);
        if (infDir.equals("WEB-INF")) {
            WebAppType webApp = (WebAppType)new WebDeploymentDescriptorFile().getDeploymentDescriptor(archive);
            pair = new WebservicesPair(stdDD, extDD, webApp);
        } else {
            pair = new WebservicesPair(stdDD, extDD);
        }
        return pair;
    }

    public HashMap getPcName2UrlMap() {
        return this.pcName2UrlMap;
    }

    public String getContext() {
        return this.context;
    }

    public String getPortComponentNameByEjbLinkName(String ejbLinkName) {
        List descs = this.stdDD.getWebserviceDescription();
        for (WebserviceDescriptionType desc : descs) {
            List pcs = desc.getPortComponent();
            for (PortComponentType pc : pcs) {
                String pcName = pc.getPortComponentName().getValue();
                String linkName = pc.getServiceImplBean().getEjbLink().getValue();
                if (!ejbLinkName.equals(linkName)) continue;
                return pcName;
            }
        }
        return null;
    }

    public String getPortComponentNameByPortQName(QName portQName) {
        List descs = this.stdDD.getWebserviceDescription();
        for (WebserviceDescriptionType desc : descs) {
            List pcs = desc.getPortComponent();
            for (PortComponentType pc : pcs) {
                String pcName = pc.getPortComponentName().getValue();
                QName qname = pc.getWsdlPort().getValue();
                if (!portQName.equals(qname)) continue;
                return pcName;
            }
        }
        if (!descs.isEmpty()) {
            throw new IllegalStateException("NOT found the wsdl-port in 'webservices.xml' : " + portQName);
        }
        return null;
    }

    public String getServiceImplServletLinkName(String pcName) {
        PortComponentType pc = this.getPortComponent(pcName);
        ServletLinkType servletLink = pc.getServiceImplBean().getServletLink();
        if (servletLink != null) {
            return servletLink.getValue();
        }
        return null;
    }

    public String getServiceImplEjbLinkName(String pcName) {
        PortComponentType pc = this.getPortComponent(pcName);
        EjbLinkType ejbLink = pc.getServiceImplBean().getEjbLink();
        if (ejbLink != null) {
            return ejbLink.getValue();
        }
        return null;
    }

    public String getServiceEndpointInterfaceName(String pcName) {
        PortComponentType pc = this.getPortComponent(pcName);
        return pc.getServiceEndpointInterface().getValue();
    }

    public String getTieClassByPortComponentName(String pcName) {
        PortType port = JeusWebservicesDDBindingHelper.getPort(this.extDD, pcName);
        if (port != null) {
            return port.getTieClass();
        }
        return null;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public WebAppType getWebApp() {
        return this.webApp;
    }

    public HashMap<String, String> getServletNameToUrlMap() {
        return this.servletNameToUrlMap;
    }

    public static ServletMappingType getServletMapping(WebAppType webStdDD, String servletName) {
        for (ServletMappingType entry : WebservicesPair.getServletMappings(webStdDD)) {
            if (!servletName.equals(entry.getServletName().getValue())) continue;
            return entry;
        }
        return null;
    }

    private static List<ServletMappingType> getServletMappings(WebAppType webStdDD) {
        return BindingHelper.getSubList(webStdDD.getDescriptionAndDisplayNameAndIcon(), ServletMappingType.class);
    }
}

