/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.TransformerException;
import jeus.xml.binding.DescriptorBinder;
import jeus.xml.binding.NamespaceConverter;
import jeus.xml.binding.j2ee.ApplicationType;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.jeusDD.AccountsType;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.EjbEngineType;
import jeus.xml.binding.jeusDD.JeusClientDdType;
import jeus.xml.binding.jeusDD.JeusConnectorDdType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.JeusWebservicesDdType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.LibrariesType;
import jeus.xml.binding.jeusDD.PoliciesType;
import jeus.xml.binding.jeusDD.VirtualHostsType;
import jeus.xml.binding.jeusDD.WebContainerType;
import jeus.xml.binding.jeusDD.WebServicesConfigType;
import jeus.xml.binding.util.JeusBinding;
import jeus.xml.binding.util.JeusBindingInterface;
import jeus.xml.util.ClasspathLocation;
import jeus.xml.util.CommentExtractor;
import jeus.xml.util.DomProcessor;
import jeus.xml.util.ElementException;
import jeus.xml.util.ElementOrderTable;
import jeus.xml.util.ElementOrderTableSource;
import jeus.xml.util.ElementSort;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import jeus.xml.util.XPathComment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSurgeon {
    private static final String JAXB_ENCODING_KEY = "jeus.xml.binding.encoding";
    private static final String ORIGINAL_NAMESPACE_KEY = "jeus.xml.binding.originalNS";
    private static ElementOrderTableSource tsrc;

    public static Object operate(Unmarshaller u, InputStream in) throws JAXBException, SAXException, IOException, ElementException {
        return XMLSurgeon.operate(u, in, true, true);
    }

    public static DescriptorBinder operate(Binder u, InputStream in) throws JAXBException, SAXException, IOException, ElementException {
        return XMLSurgeon.operate(u, in, true, true);
    }

    public static void leave(Object obj, Marshaller m, OutputStream os) throws SAXException, JAXBException, IOException {
        XMLSurgeon.leave(obj, m, os, true);
    }

    public static Object operate(Unmarshaller u, InputStream in, boolean keepComments, boolean elementReorder) throws JAXBException, SAXException, IOException, ElementException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
        String originalNS = NamespaceConverter.convertJaveEe4Document(in, out);
        Document doc = DomProcessor.parse(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        assert (doc != null);
        Object obj = XMLSurgeon.operateJavaEeDocument(u, doc, keepComments, elementReorder);
        XMLSurgeon.setOriginalNamespace(obj, originalNS);
        return obj;
    }

    public static DescriptorBinder operate(Binder u, InputStream in, boolean keepComments, boolean elementReorder) throws JAXBException, SAXException, IOException, ElementException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String originalNS = NamespaceConverter.convertJaveEe4Document(in, out);
        Document doc = DomProcessor.parse(new ByteArrayInputStream(out.toByteArray()));
        assert (doc != null);
        DescriptorBinder binder = XMLSurgeon.operateJavaEeDocument(u, doc, keepComments, elementReorder);
        XMLSurgeon.setOriginalNamespace(binder.getObject(), originalNS);
        return binder;
    }

    public static Object operate(Unmarshaller u, Document doc, boolean keepComments, boolean elementReorder) throws ElementException, JAXBException {
        String originalNS = NamespaceConverter.getNamespace(doc);
        doc = NamespaceConverter.convertJ2EE14Document(doc);
        assert (doc != null);
        Object obj = XMLSurgeon.operateJavaEeDocument(u, doc, keepComments, elementReorder);
        XMLSurgeon.setOriginalNamespace(obj, originalNS);
        return obj;
    }

    private static Object operateJavaEeDocument(Unmarshaller u, Document doc, boolean keepComments, boolean elementReorder) throws ElementException, JAXBException {
        String encoding;
        Object obj;
        ElementOrderTable t;
        List comments = null;
        if (keepComments) {
            CommentExtractor extractor = new CommentExtractor();
            comments = extractor.extract(doc);
        }
        if (elementReorder && (t = tsrc.getElementOrderTable(doc)) != null) {
            ElementSort.sort(doc, t);
        }
        if ((obj = u.unmarshal((Node)doc)) instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        if ((encoding = doc.getXmlEncoding()) == null) {
            encoding = "UTF-8";
        }
        XMLSurgeon.setEncoding(obj, encoding);
        if (keepComments) {
            XMLSurgeon.attachComments(comments, obj);
        }
        return obj;
    }

    private static DescriptorBinder operateJavaEeDocument(Binder u, Document doc, boolean keepComments, boolean elementReorder) throws ElementException, JAXBException {
        String encoding;
        Object obj;
        ElementOrderTable t;
        List comments = null;
        if (keepComments) {
            CommentExtractor extractor = new CommentExtractor();
            comments = extractor.extract(doc);
        }
        if (elementReorder && (t = tsrc.getElementOrderTable(doc)) != null) {
            ElementSort.sort(doc, t);
        }
        if ((obj = u.unmarshal((Object)doc)) instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        if ((encoding = doc.getXmlEncoding()) == null) {
            encoding = "UTF-8";
        }
        XMLSurgeon.setEncoding(obj, encoding);
        if (keepComments) {
            XMLSurgeon.attachComments(comments, obj);
        }
        return new DescriptorBinder(obj, u);
    }

    private static void setEncoding(Object obj, String encoding) {
        if (obj instanceof JeusBinding) {
            ((JeusBinding)obj).getInfoMap().put(JAXB_ENCODING_KEY, encoding);
        } else if (obj instanceof JeusBindingInterface) {
            ((JeusBindingInterface)obj).getInfoMap().put(JAXB_ENCODING_KEY, encoding);
        } else {
            return;
        }
    }

    public static String getEncoding(Object obj) {
        if (obj instanceof JeusBinding) {
            String encoding = (String)((JeusBinding)obj).getInfoMap().get(JAXB_ENCODING_KEY);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return encoding;
        }
        if (obj instanceof JeusBindingInterface) {
            String encoding = (String)((JeusBindingInterface)obj).getInfoMap().get(JAXB_ENCODING_KEY);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return encoding;
        }
        return "UTF-8";
    }

    private static void setOriginalNamespace(Object obj, String originalNS) {
        if (obj instanceof JeusBinding) {
            ((JeusBinding)obj).getInfoMap().put(ORIGINAL_NAMESPACE_KEY, originalNS);
        } else if (obj instanceof JeusBindingInterface) {
            ((JeusBindingInterface)obj).getInfoMap().put(ORIGINAL_NAMESPACE_KEY, originalNS);
        } else {
            return;
        }
    }

    private static String getOriginalNamespace(Object obj) {
        if (obj instanceof JeusBinding) {
            return (String)((JeusBinding)obj).getInfoMap().get(ORIGINAL_NAMESPACE_KEY);
        }
        if (obj instanceof JeusBindingInterface) {
            return (String)((JeusBindingInterface)obj).getInfoMap().get(ORIGINAL_NAMESPACE_KEY);
        }
        return null;
    }

    public static void leave(Object obj, Marshaller m, OutputStream os, boolean keepComments) throws SAXException, IOException, JAXBException {
        XPathComment comment;
        int i;
        IXPathAPI xpathAPI;
        List comments;
        CommentExtractor extractor;
        String encoding = XMLSurgeon.getEncoding(obj);
        String originalNS = XMLSurgeon.getOriginalNamespace(obj);
        m.setProperty("jaxb.encoding", (Object)encoding);
        Document doc = DomProcessor.createEmptyDocument();
        Object element = XMLSurgeon.createJAXBElement(obj);
        m.marshal(element, (Node)doc);
        doc = NamespaceConverter.restoreOriginalNamespace(doc, originalNS);
        if (obj instanceof JeusBinding && keepComments) {
            extractor = new CommentExtractor();
            comments = extractor.extract((JeusBinding)obj);
            xpathAPI = XPathAPIFactory.createXPathAPI();
            for (i = 0; i < comments.size(); ++i) {
                comment = (XPathComment)comments.get(i);
                comment.locate(doc, xpathAPI);
            }
        }
        if (obj instanceof JeusBindingInterface && keepComments) {
            extractor = new CommentExtractor();
            comments = extractor.extract((JeusBindingInterface)obj);
            xpathAPI = XPathAPIFactory.createXPathAPI();
            for (i = 0; i < comments.size(); ++i) {
                comment = (XPathComment)comments.get(i);
                comment.locate(doc, xpathAPI);
            }
        }
        DomProcessor.serialize(doc, os);
    }

    private static Object createJAXBElement(Object obj) {
        if (obj instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        jeus.xml.binding.jeusDD.ObjectFactory objFact = new jeus.xml.binding.jeusDD.ObjectFactory();
        ObjectFactory j2eeObjFact = new ObjectFactory();
        if (obj instanceof JeusSystemType) {
            return objFact.createJeusSystem((JeusSystemType)obj);
        }
        if (obj instanceof WebContainerType) {
            return objFact.createWebContainer((WebContainerType)obj);
        }
        if (obj instanceof EjbEngineType) {
            return objFact.createEjbEngine((EjbEngineType)obj);
        }
        if (obj instanceof JmsServerType) {
            return objFact.createJmsServer((JmsServerType)obj);
        }
        if (obj instanceof VirtualHostsType) {
            return objFact.createVirtualHosts((VirtualHostsType)obj);
        }
        if (obj instanceof AccountsType) {
            return objFact.createAccounts((AccountsType)obj);
        }
        if (obj instanceof PoliciesType) {
            return objFact.createPolicies((PoliciesType)obj);
        }
        if (obj instanceof ContextType) {
            return objFact.createJeusWebDd((ContextType)obj);
        }
        if (obj instanceof WebServicesConfigType) {
            return objFact.createWebServicesConfig((WebServicesConfigType)obj);
        }
        if (obj instanceof JeusWebservicesDdType) {
            return objFact.createJeusWebservicesDd((JeusWebservicesDdType)obj);
        }
        if (obj instanceof JeusEjbDdType) {
            return objFact.createJeusEjbDd((JeusEjbDdType)obj);
        }
        if (obj instanceof JeusClientDdType) {
            return objFact.createJeusClientDd((JeusClientDdType)obj);
        }
        if (obj instanceof JeusConnectorDdType) {
            return objFact.createJeusConnectorDd((JeusConnectorDdType)obj);
        }
        if (obj instanceof ApplicationType) {
            return j2eeObjFact.createApplication((ApplicationType)obj);
        }
        if (obj instanceof LibrariesType) {
            return objFact.createLibraries((LibrariesType)obj);
        }
        throw new RuntimeException(obj.getClass().getName());
    }

    private static void attachComments(List comments, Object obj) {
        if (obj instanceof JeusBinding) {
            HashMap bindingMap = new HashMap();
            Document jdoc = JeusBinding.createDocument((JeusBinding)((JeusBinding)obj), bindingMap);
            IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
            for (int i = 0; i < comments.size(); ++i) {
                NodeList nodeList;
                XPathComment comment = (XPathComment)comments.get(i);
                try {
                    nodeList = xpathAPI.selectNodeList(jdoc, comment.getXPath());
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    continue;
                }
                Node node = nodeList.item(0);
                JeusBinding binding = comment.getPosition().getValue() == 2 ? (JeusBinding)bindingMap.get(node) : (node != null && node.getParentNode() != null && node.getParentNode().getNodeType() == 1 ? (JeusBinding)bindingMap.get(node.getParentNode()) : (JeusBinding)bindingMap.get(node));
                if (binding == null) continue;
                binding.getComments().add(comment);
            }
        } else if (obj instanceof JeusBindingInterface) {
            HashMap<Element, Object> bindingMap = new HashMap<Element, Object>();
            String name = JeusBinding.getElementNameFromClass(obj.getClass());
            Document doc = DomProcessor.createEmptyDocument();
            Element root = ((JeusBindingInterface)obj).createElement(doc, name, bindingMap);
            bindingMap.put(root, obj);
            doc.appendChild(root);
            IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
            for (int i = 0; i < comments.size(); ++i) {
                NodeList nodeList;
                XPathComment comment = (XPathComment)comments.get(i);
                try {
                    nodeList = xpathAPI.selectNodeList(doc, comment.getXPath());
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    continue;
                }
                Node node = nodeList.item(0);
                JeusBindingInterface binding = comment.getPosition().getValue() == 2 ? (JeusBindingInterface)bindingMap.get(node) : (node != null && node.getParentNode() != null && node.getParentNode().getNodeType() == 1 ? (JeusBindingInterface)bindingMap.get(node.getParentNode()) : (JeusBindingInterface)bindingMap.get(node));
                if (binding == null) continue;
                binding.getComments().add(comment);
            }
        } else {
            return;
        }
    }

    static {
        try {
            tsrc = new ElementOrderTableSource(new ClasspathLocation("jeus/xml/binding/resource"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

