/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.IXPathLocatable;
import jeus.xml.util.XPathPositionType;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathComment
implements IXPathLocatable,
Serializable {
    private String comment;
    private String xpath;
    private XPathPositionType position;

    public XPathComment(String xpath, XPathPositionType position, String comment) {
        this.comment = comment;
        this.position = position;
        this.xpath = xpath;
    }

    public String getComment() {
        return this.comment;
    }

    public XPathPositionType getPosition() {
        return this.position;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String xpath) {
        this.xpath = xpath;
    }

    public void locate(Document doc, IXPathAPI xpathAPI) {
        try {
            String prefix = doc.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            String prefixedXPath = this.xpath.replaceAll("/", "/" + prefix + ":");
            NodeList nodeList = xpathAPI.selectNodeList(doc, prefixedXPath);
            Comment c = doc.createComment(this.comment);
            if (nodeList.getLength() > 0) {
                Element found = (Element)nodeList.item(0);
                Node parent = found.getParentNode();
                if (parent == null) {
                    parent = found.getOwnerDocument();
                }
                switch (this.position.getValue()) {
                    case 0: {
                        parent.insertBefore(c, found);
                        break;
                    }
                    case 1: {
                        Node next = found.getNextSibling();
                        if (next == null) {
                            parent.appendChild(c);
                            break;
                        }
                        parent.insertBefore(c, next);
                        break;
                    }
                    case 2: {
                        found.appendChild(c);
                    }
                }
            } else {
                if (2 == this.position.getValue()) {
                    return;
                }
                int p = prefixedXPath.lastIndexOf(91);
                String siblingPath = prefixedXPath.substring(0, p);
                p = prefixedXPath.lastIndexOf(47);
                String parentPath = prefixedXPath.substring(0, p);
                NodeList siblings = xpathAPI.selectNodeList(doc, siblingPath);
                if (siblings.getLength() > 0) {
                    Node sibling = siblings.item(siblings.getLength() - 1);
                    Node next = sibling.getNextSibling();
                    if (next != null) {
                        sibling.getParentNode().insertBefore(c, next);
                    } else {
                        sibling.getParentNode().appendChild(c);
                    }
                } else {
                    NodeList parentList = xpathAPI.selectNodeList(doc, parentPath);
                    if (parentList.getLength() > 0) {
                        Node parent = parentList.item(0);
                        parent.appendChild(c);
                    }
                }
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

