/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility;

import java.util.LinkedList;
import javax.jms.JMSException;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.facility.TemporaryDestinationManager;
import jeus.jms.client.facility.consumer.LocalMessageConsumerFacility;
import jeus.jms.common.destination.TemporaryDestination;
import jeus.jms.common.message.ClientMessage;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS2;

public class TemporaryQueueManager
extends TemporaryDestinationManager {
    private LinkedList messages = new LinkedList();
    private LocalMessageConsumerFacility consumer;

    public TemporaryQueueManager(TemporaryDestination dest) {
        super(dest);
    }

    synchronized boolean distribute(ClientMessage message) throws JMSException {
        if (this.consumer == null || !this.consumer.isAcceptable(message)) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2111_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2111_LEVEL, JeusMessage_JMS2._2111, message.getMessageID());
            }
            this.messages.add(message);
            return false;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2112_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2112_LEVEL, JeusMessage_JMS2._2112, new Object[]{message.getMessageID(), this.consumer});
        }
        this.consumer.handleMessage(message);
        return true;
    }

    public synchronized void setConsumer(LocalMessageConsumerFacility consumer) {
        this.consumer = consumer;
        if (consumer == null || this.messages.isEmpty()) {
            return;
        }
        this.execution.recover((MessageEventProvider)consumer, this.messages);
        this.messages.clear();
        this.execution.startExecution();
    }

    public synchronized void unsetConsumer() {
        this.consumer = null;
    }

    public void addConsumer(LocalMessageConsumerFacility consumer) {
        this.setConsumer(consumer);
    }

    public void removeConsumer(LocalMessageConsumerFacility consumer) {
        this.unsetConsumer();
    }

    public synchronized boolean consumerAttatched() {
        return this.consumer != null;
    }
}

