/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.browser;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class JeusQueueBrowser
implements QueueBrowser {
    private final Queue queue;
    private final String selector;
    private final List messages;
    private boolean closed;

    public JeusQueueBrowser(Queue queue, String selector, List messages) {
        this.queue = queue;
        this.selector = selector;
        this.messages = messages;
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkClosed();
        return Collections.enumeration(this.messages);
    }

    public void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
    }

    private boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException("queue browser " + this + " is already closed");
        }
    }

    public String toString() {
        return "QueueBrowser[" + this.queue + (this.selector == null || this.selector.equals("") ? "" : ":" + this.selector) + "]";
    }
}

