/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.consumer;

import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.util.ClientSerialExecutable;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.util.JMSSyncRequest;

public abstract class ClientMessageQueue
extends ClientSerialExecutable
implements MessageEventProvider {
    public void shutdownExecutor() throws JMSException {
        this.setSuspend(true);
        this.returnMessages();
        this.notifyShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMessage acquireMessage(long timeout) throws JMSException {
        ClientMessage message = this.dequeueWork();
        if (message != null) {
            return message;
        }
        JMSSyncRequest request = this.sendSyncMessageRequest(timeout);
        try {
            ClientMessage clientMessage = (ClientMessage)request.waitResult(timeout);
            return clientMessage;
        }
        finally {
            this.cancelSyncRequest(request);
        }
    }

    void setAsyncDelivery(boolean async) throws JMSException {
        if (!async) {
            this.returnMessages();
        }
        this.sendAsyncMessageRequest(async);
    }

    private void returnMessages() throws JMSException {
        LinkedList remain = this.getWorks();
        this.sendMessageEvent((byte)48, remain);
        this.clearWorks();
    }

    private void sendAsyncMessageRequest(boolean async) throws JMSException {
        AdminMessage request = this.createAdminMessage((byte)33);
        request.setBooleanFlag(async);
        this.sendNotifyMessage(request);
    }

    private JMSSyncRequest sendSyncMessageRequest(long timeout) throws JMSException {
        AdminMessage request = this.createAdminMessage((byte)32);
        request.setBooleanFlag(timeout == -1L);
        request.setLongFlag(timeout);
        return this.sendSyncRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdown() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.works.notifyAll();
        }
    }

    private void sendMessageEvent(byte opcode, List works) throws JMSException {
        if (!works.isEmpty()) {
            MessageHandleEvent event = this.createMessageEvent(opcode, works);
            this.sendNotifyMessage(event);
        }
    }
}

