/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.consumer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import jeus.jms.client.facility.Freezer;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.facility.TemporaryDestinationManager;
import jeus.jms.client.facility.consumer.ClientMessageQueue;
import jeus.jms.client.facility.consumer.LocalMessageConsumerFacility;
import jeus.jms.client.facility.session.JeusSession;
import jeus.jms.common.destination.TemporaryDestination;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.message.selector.BooleanExpression;
import jeus.jms.common.message.selector.grammar.SelectorParser;
import jeus.jms.common.util.AcknowledgeManager;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSSyncRequest;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Journal;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS2;

public class JeusLocalMessageConsumer
extends ClientMessageQueue
implements LocalMessageConsumerFacility {
    private SynchronizedInt sequencer;
    private SynchronizedBoolean closed;
    private final TemporaryDestination destination;
    private final TemporaryDestinationManager manager;
    private int consumerID;
    private JeusSession session;
    private AcknowledgeManager ackManager;
    private List requests;
    private String consumerName;
    private String selector;
    private boolean noLocal;
    private MessageListener listener;
    private BooleanExpression selectable;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JeusLocalMessageConsumer(Session session, TemporaryDestinationManager manager, String selector, boolean noLocal) {
        this.manager = manager;
        this.selector = this.trimSelector(selector);
        this.noLocal = noLocal;
        this.session = (JeusSession)session;
        this.destination = manager.getDestination();
        this.initialize();
    }

    void initialize() {
        this.sequencer = new SynchronizedInt(0);
        this.ackManager = new AcknowledgeManager(this.session.getSessionID(), this);
        this.closed = new SynchronizedBoolean(false);
        this.requests = new LinkedList();
    }

    void initializeSelector() throws JMSException {
        try {
            this.selectable = new SelectorParser().parse(this.selector);
        }
        catch (Exception e) {
            throw new InvalidSelectorException(e.getMessage());
        }
    }

    public void createFacility() throws JMSException {
        this.consumerID = this.session.getTemporaryConsumerID();
        this.consumerName = this.session.getFacilityName() + this.getPartialIdentity() + this.consumerID;
        this.session.addedConsumer(this.consumerID, this);
        if (this.selector != null) {
            this.initializeSelector();
        }
    }

    public AdminMessage sendAdminMessage(AdminMessage adminMessage) throws JMSException {
        throw new UnsupportedOperationException("send is not supported operation.");
    }

    public AdminMessage sendAdminMessage(byte opcode) throws JMSException {
        throw new UnsupportedOperationException("send is not supported operation.");
    }

    public void recoverFacility() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2141_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2141_LEVEL, JeusMessage_JMS2._2141, this);
        }
    }

    public boolean isAcceptable(ClientMessage message) {
        if (this.noLocal && this.destination.getTemporaryID() == message.getMessageID().getEntryID()) {
            return false;
        }
        if (this.selectable != null) {
            return this.selectable.matches(message);
        }
        return true;
    }

    public void handleMessage(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2142_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2142_LEVEL, JeusMessage_JMS2._2142, new Object[]{packet, this});
        }
        if (packet.isAdminMessage()) {
            this.handleAdminMessage((AdminMessage)packet);
        } else {
            this.handleUserMessage((ClientMessage)packet);
        }
    }

    public void handleException(MessageContainer packet, JMSException ex) {
    }

    private void handleAdminMessage(AdminMessage message) {
        message.getOperationID();
    }

    private void handleUserMessage(ClientMessage message) {
        this.prepareMessage(message);
        this.enqueueMessage(message);
    }

    public void startFacility() throws JMSException {
        AdminMessage start = this.createAdminMessage((byte)4);
        this.sendNotifyMessage(start);
        this.setSuspend(false);
        if (this.isAsyncDelivery()) {
            this.startExecution();
        }
    }

    public void stopFacility() throws JMSException {
        this.setSuspend(true);
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        if (listener != null) {
            this.cancelRequests();
        }
        this.listener = listener;
        this.setAsyncDelivery(listener != null);
        if (!this.isEmpty()) {
            this.startExecution();
        }
    }

    public void onMessage(Message message) {
        this.listener.onMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(ClientMessage message) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2143_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2143_LEVEL, JeusMessage_JMS2._2143, new Object[]{this.requests, this});
            }
            Iterator it = this.requests.iterator();
            while (it.hasNext()) {
                JMSSyncRequest request = (JMSSyncRequest)it.next();
                it.remove();
                if (!request.messageArrived(message)) continue;
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2144_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2144_LEVEL, JeusMessage_JMS2._2144, new Object[]{message.getMessageID(), this});
                }
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2145_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS2._2145_LEVEL, JeusMessage_JMS2._2145, new Object[]{message.getMessageID(), this});
            }
            this.enqueueWork(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSSyncRequest registerRequest() {
        JMSSyncRequest request = new JMSSyncRequest(this.sequencer.increment());
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            if (this.isEmpty()) {
                this.requests.add(request);
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2146_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2146_LEVEL, JeusMessage_JMS2._2146, new Object[]{request, this});
                }
            } else {
                ClientMessage message = this.dequeueWork();
                request.messageReady(message);
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2147_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2147_LEVEL, JeusMessage_JMS2._2147, new Object[]{message, request});
                }
            }
        }
        return request;
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(1000L);
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        ClientMessage message = this.acquireMessage(timeout);
        return this.afterReceive(message);
    }

    private Message afterReceive(ClientMessage message) {
        block3: {
            if (message == null) {
                return null;
            }
            this.prepareMessage(message);
            this.session.enlistGlobalTransaction();
            int ackmode = this.session.getAcknowledgeMode();
            message.consuming(ackmode);
            try {
                message.consumed(ackmode);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS2._2148_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS2._2148_LEVEL, JeusMessage_JMS2._2148, e);
            }
        }
        return message;
    }

    private void prepareMessage(ClientMessage message) {
        message.prepareMessage();
        message.setExecutionSession(this.session);
        message.setExecutionContext(this.ackManager);
    }

    public void recoverConsumed() throws JMSException {
        if (this.ackManager.isEmpty()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2149_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2149_LEVEL, JeusMessage_JMS2._2149, new Object[]{this, this.ackManager});
        }
        this.ackManager.recoverRemote();
    }

    public void acknowledgeConsumed(boolean transacted) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2150_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2150_LEVEL, JeusMessage_JMS2._2150, new Object[]{this, this.ackManager});
        }
        this.ackManager.acknowledge(transacted);
    }

    public void clearConsumed(boolean transacted) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2151_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2151_LEVEL, JeusMessage_JMS2._2151, new Object[]{this, this.ackManager});
        }
        this.ackManager.clearConsumed(transacted);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void closeFacility() throws JMSException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2152_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2152_LEVEL, JeusMessage_JMS2._2152, this);
        }
        this.stopFacility();
        try {
            this.shutdownExecutor();
        }
        finally {
            if (this.session.asyncAcknowledge() && !this.ackManager.isEmpty()) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2153_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS2._2153_LEVEL, JeusMessage_JMS2._2153, this);
                }
                this.session.addFinishWork(new ShutdownWork());
            } else {
                this.shutdown();
            }
            this.cancelRequests();
        }
    }

    void shutdown() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS2._2154_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS2._2154_LEVEL, JeusMessage_JMS2._2154, this);
        }
        this.destination.consumerClosed(this);
        this.ackManager.clearConsumed(false);
        this.session.removedConsumer(this.consumerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRequests() {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            for (int i = 0; i < this.requests.size(); ++i) {
                JMSSyncRequest request = (JMSSyncRequest)this.requests.get(i);
                request.cancel();
            }
            this.requests.clear();
        }
    }

    public MessageHandleEvent createMessageEvent(byte opcode, ClientMessage message) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, message);
        this.setFacilityTarget(event);
        return event;
    }

    public MessageHandleEvent createMessageEvent(byte opcode, List works) {
        MessageHandleEvent event = MessageUtil.createEventMessage(opcode, works);
        this.setFacilityTarget(event);
        return event;
    }

    public AdminMessage createAdminMessage(byte opcode) {
        AdminMessage admin = MessageUtil.createAdminMessage(opcode);
        this.setFacilityTarget(admin);
        return admin;
    }

    private void setFacilityTarget(AdminMessage event) {
        event.setTargetID((byte)31);
        event.setConsumerID(this.consumerID);
    }

    public void sendNotifyMessage(MessageContainer packet) {
        try {
            this.manager.handleMessage(packet);
        }
        catch (JMSException e) {
            this.manager.handleException(packet, e);
        }
    }

    public JMSSyncRequest sendSyncRequest(MessageContainer packet) {
        return this.registerRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSyncRequest(JMSSyncRequest request) {
        LinkedList linkedList = this.works;
        synchronized (linkedList) {
            this.requests.remove(request);
        }
    }

    private String trimSelector(String selector) {
        return selector != null && selector.trim().equals("") ? null : selector;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public boolean isClosed() {
        return this.session.isClosed() || this.closed.get();
    }

    public void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4271, 1);
        }
    }

    public String getFacilityName() {
        return this.consumerName;
    }

    public Journal getLogger() {
        return logger;
    }

    private boolean isAsyncDelivery() {
        return this.listener != null;
    }

    String getPartialIdentity() {
        return ".LMC";
    }

    public String toString() {
        return this.consumerName;
    }

    public void preExecution(ClientMessage message) throws JMSException {
        message.setMessageListener(this.listener);
    }

    public boolean execute(ClientMessage message) throws Exception {
        this.session.enqueueAsyncMessages((byte)31, message);
        return true;
    }

    public void exception(ClientMessage message, JMSException e) {
        this.recover((MessageEventProvider)this, message);
    }

    public void workCompleted() {
        this.session.run();
    }

    public void freeze(Freezer freezer) {
    }

    public void thaw(Freezer freezer) {
    }

    protected void messageAvailable() {
        if (this.isAsyncDelivery() || this.isClosed()) {
            this.startExecution();
        }
        this.works.notify();
    }

    private class ShutdownWork
    implements Runnable {
        private ShutdownWork() {
        }

        public void run() {
            JeusLocalMessageConsumer.this.shutdown();
        }

        public String toString() {
            return "SHUTDOWN " + JeusLocalMessageConsumer.this;
        }
    }
}

