/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.facility.factory;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.JMSServerEntryFactory;
import jeus.jms.client.event.EventService;
import jeus.jms.client.event.EventServiceFactory;
import jeus.jms.client.event.JeusEventService;
import jeus.jms.client.facility.connection.JeusConnection;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.pool.JeusServerSessionPool;
import jeus.jms.common.pool.SessionPoolManager;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.security.base.Subject;
import jeus.security.resource.Password;
import jeus.security.util.LoginUtil;
import jeus.util.UpdatableReference;

public class JeusConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
EventServiceFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = -8483422331581762526L;
    public static final String ANONYMOUS_FACTORY_NAME = "anonymous";
    public static final String OBJECT_FACTORY = "jeus.jms.client.facility.factory.ConnectionFactoryOF";
    public static final String FACTORY_NAME = "factoryName";
    public static final String FACTORY_TYPE = "type";
    public static final String BROKER_ADDRESSES = "addresses";
    public static final String MAX_THREAD = "maxThread";
    public static final String CLIENT_ID = "clientID";
    public static final String CLIENT_ID_TYPE = "fixed";
    public static final String XA_SUPPORT = "xaSupport";
    public static final String XA_RECOVERY = "xaRecovery";
    public static final String SSL_SUPPORT = "sslSupport";
    public static final String BROKER_SELECTION_POLICY = "brokerSelectionPolicy";
    protected String factoryName;
    protected int factoryType;
    protected HashSet addresses;
    protected boolean sslSupport;
    protected boolean xaSupport;
    protected boolean xaRecovery;
    protected boolean cluster;
    protected String clientID;
    protected boolean fixed;
    protected int maxThread = 100;
    protected String policyType = "round-robin";
    protected transient String factoryDesc;

    public JeusConnectionFactory() {
    }

    public JeusConnectionFactory(JMSServiceChannelAddress address) {
        this(ANONYMOUS_FACTORY_NAME, address);
    }

    public JeusConnectionFactory(String factoryName, JMSServiceChannelAddress address) {
        this.factoryName = factoryName;
        this.factoryType = 120;
        this.addBrokerAddress(address);
    }

    public JeusConnectionFactory(String factoryName, JMSServiceChannelAddress address, int maxThread, String clientID, boolean fixed) {
        this.factoryName = factoryName;
        this.factoryType = 120;
        this.maxThread = maxThread < 10 ? 10 : maxThread;
        this.clientID = clientID;
        this.fixed = fixed;
        this.addBrokerAddress(address);
    }

    public JeusConnectionFactory(String factoryName, int factoryType, HashSet addresses, String policyType, int maxThread, String clientID, boolean fixed, boolean ssl, boolean cluster) {
        this.factoryName = factoryName;
        this.factoryType = factoryType;
        this.addresses = addresses;
        this.policyType = policyType;
        this.clientID = clientID;
        this.fixed = fixed;
        this.maxThread = maxThread < 10 ? 10 : maxThread;
        this.sslSupport = ssl;
        this.cluster = cluster;
    }

    public void addBrokerAddress(JMSServiceChannelAddress address) {
        if (this.addresses == null) {
            this.addresses = new HashSet();
        }
        this.addresses.add(address);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public int getFactoryType() {
        return this.factoryType;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isFixedClientID() {
        return this.fixed;
    }

    public boolean isSupportSSL() {
        return this.sslSupport;
    }

    public boolean isClusterBinding() {
        return this.cluster;
    }

    public HashSet getAddresses() {
        return this.addresses;
    }

    public int getMaxSessionThread() {
        return this.maxThread;
    }

    public String getBrokerSelectionPolicyType() {
        return this.policyType;
    }

    public String getDescription() {
        return this.factoryDesc != null ? this.factoryDesc : (this.factoryDesc = this.createDescription());
    }

    public String createDescription() {
        return "[" + this.factoryName + (this.clientID == null ? "" : "(" + (this.fixed ? CLIENT_ID_TYPE : "auto") + ":" + this.clientID + ")") + this.addresses + "]";
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.factoryType);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, this.factoryType);
    }

    private Connection createConnection(String userName, String password, int type) throws JMSException {
        JMSServerEntry entry = this.createJMSServerEntry();
        JeusConnection con = new JeusConnection(entry, this.clientID, this.fixed, type);
        con.createConnection(userName, password);
        return con;
    }

    public ServerSessionPool createSessionPool(SessionPoolManager manager, String userName, String password, int type) throws JMSException {
        JMSServerEntry entry = this.createJMSServerEntry();
        JeusServerSessionPool con = new JeusServerSessionPool(entry, manager, this.clientID, this.fixed, type);
        con.createConnection(userName, password);
        return con;
    }

    JMSServerEntry createJMSServerEntry() throws JMSException {
        return JMSServerEntryFactory.createServerEntry(this.addresses, this.policyType, this.maxThread, this.sslSupport, this.xaRecovery);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection(81);
    }

    private Connection createConnection(int type) throws JMSException {
        Object[] result = this.getCurrentUserPasswords();
        String userName = (String)result[0];
        String[] passwords = (String[])result[1];
        if (userName != null && passwords != null) {
            for (int i = 0; i < passwords.length; ++i) {
                String password = passwords[i];
                try {
                    return this.createConnection(userName, password, type);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    continue;
                }
            }
        }
        return this.createConnection(null, null, type);
    }

    private Object[] getCurrentUserPasswords() {
        Subject subject = LoginUtil.getLatestUserSubjectWithRuntimeException();
        String userName = null;
        String[] passwords = null;
        if (subject != null && subject.getPrincipal() != null) {
            userName = subject.getPrincipal().getName();
            Set credentials = subject.getCredentials(Password.class);
            passwords = new String[credentials.size()];
            Iterator it = credentials.iterator();
            int index = 0;
            while (it.hasNext()) {
                Password password = (Password)it.next();
                passwords[index++] = password.getPassword();
            }
        }
        return new Object[]{userName, passwords};
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public EventService createEventService() throws JMSException {
        TopicConnection connection = this.createTopicConnection();
        TopicSession session = connection.createTopicSession(false, 1);
        return new JeusEventService((Connection)connection, (Session)session);
    }

    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        ref.add(new StringRefAddr(FACTORY_NAME, this.factoryName));
        ref.add(new StringRefAddr(CLIENT_ID, this.clientID));
        ref.add((RefAddr)new SerializableRefAddr(FACTORY_TYPE, (Serializable)new Integer(this.factoryType)));
        ref.add((RefAddr)new SerializableRefAddr(MAX_THREAD, (Serializable)new Integer(this.maxThread)));
        ref.add(new StringRefAddr(BROKER_SELECTION_POLICY, this.policyType));
        ref.add((RefAddr)new SerializableRefAddr(CLIENT_ID_TYPE, (Serializable)(this.fixed ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr(XA_SUPPORT, (Serializable)(this.xaSupport ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr(XA_RECOVERY, (Serializable)(this.xaRecovery ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr(SSL_SUPPORT, (Serializable)(this.sslSupport ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr(BROKER_ADDRESSES, (Serializable)this.addresses));
        return ref;
    }

    Reference createReference() {
        String className = this.getClass().getName();
        return this.cluster ? this.createClusterReference(className) : this.createReference(className);
    }

    private Reference createReference(String className) {
        return new Reference(className, OBJECT_FACTORY, null);
    }

    private Reference createClusterReference(String className) {
        return new JeusConnectionFactoryReference(className);
    }

    public String toString() {
        return "CF(" + this.factoryType + ")" + this.getDescription();
    }

    private static class JeusConnectionFactoryReference
    extends UpdatableReference {
        public JeusConnectionFactoryReference(String className) {
            super(className, JeusConnectionFactory.OBJECT_FACTORY, null);
        }

        public void addAttribute(Attribute attr) throws NamingException {
            if (!attr.getID().equals("JMS_BROKER_ADDRESS")) {
                return;
            }
            HashSet addresses = (HashSet)this.get(JeusConnectionFactory.BROKER_ADDRESSES).getContent();
            if (attr != null) {
                addresses.addAll((Collection)attr.get());
            }
        }

        public void removeAttribute(Attribute attr) throws NamingException {
            if (!attr.getID().equals("JMS_BROKER_ADDRESS")) {
                return;
            }
            HashSet addresses = (HashSet)this.get(JeusConnectionFactory.BROKER_ADDRESSES).getContent();
            addresses.removeAll((Collection)attr.get());
        }

        public void replaceAttribute(Attribute attr) throws NamingException {
            if (!attr.getID().equals("JMS_BROKER_ADDRESS")) {
                return;
            }
            HashSet addresses = (HashSet)this.get(JeusConnectionFactory.BROKER_ADDRESSES).getContent();
            addresses.clear();
            addresses.addAll((Collection)attr.get());
        }
    }
}

