/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.util;

import javax.jms.JMSException;

public class DestinationCreationArgument {
    public static final char PARAM_START_MARKER = '?';
    public static final char BROKER_START_MARKER = '@';
    public static final String PARAM_SEPARATOR = "&";
    public static final String KEY_VALUE_SEPARATOR = "=";
    public static final String PARAM_EXPORT_NAME = "export-name";
    public static final String PARAM_MULTIPLE_RECEIVER = "multiple-receiver";
    private final boolean queueType;
    private final String brokerName;
    private final String destinationName;
    private boolean creationCommand;
    private String exportName;
    private Boolean multipleReceiver;

    public DestinationCreationArgument(boolean queueType, String argStr) throws JMSException {
        String locationStr;
        this.queueType = queueType;
        if (argStr == null) {
            throw new JMSException("invalid command " + argStr);
        }
        int paramStart = argStr.indexOf(63);
        if (paramStart == -1) {
            locationStr = argStr;
        } else {
            this.creationCommand = true;
            try {
                this.parseParams(argStr.substring(paramStart + 1));
            }
            catch (Throwable t) {
                throw new JMSException("invalid command " + argStr);
            }
            locationStr = argStr.substring(0, paramStart);
        }
        int brokerStart = locationStr.indexOf(64);
        if (brokerStart == -1) {
            this.destinationName = locationStr;
            this.brokerName = null;
        } else {
            this.destinationName = locationStr.substring(0, brokerStart);
            this.brokerName = locationStr.substring(brokerStart + 1);
        }
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new JMSException("invalid command " + argStr);
        }
        if (this.brokerName != null && this.brokerName.length() == 0) {
            throw new JMSException("invalid command " + argStr);
        }
    }

    private void parseParams(String paramStr) {
        if (paramStr.length() == 0) {
            return;
        }
        String[] params = paramStr.split(PARAM_SEPARATOR);
        for (int i = 0; i < params.length; ++i) {
            String[] keyAndValue = params[i].split(KEY_VALUE_SEPARATOR);
            String key = keyAndValue[0];
            String value = keyAndValue[1];
            if (key.length() > 0 && value.length() > 0) {
                if (key.equals(PARAM_EXPORT_NAME)) {
                    if (this.exportName == null) {
                        this.exportName = value;
                        continue;
                    }
                } else if (key.equals(PARAM_MULTIPLE_RECEIVER) && this.multipleReceiver == null && this.queueType) {
                    this.multipleReceiver = Boolean.valueOf(value);
                    continue;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isCreationCommand() {
        return this.creationCommand;
    }

    public String getExportName() {
        if (this.exportName == null) {
            return this.destinationName;
        }
        return this.exportName;
    }

    public boolean getMultipleReceiver() {
        if (this.multipleReceiver == null) {
            return false;
        }
        return this.multipleReceiver;
    }
}

