/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.client.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jeus.jms.client.facility.factory.ConnectionFactoryOF;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.server.JMSServer;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.util.properties.JeusNetPropertyValues;

public class JeusConnectionFactoryCreator {
    private static JMSServer SAF_SERVER_INSTANCE;
    private String factoryName;
    private int maxThread = 10;
    private boolean xaSupport;
    private HashSet brokers = new HashSet();
    private String brokerSelectionPolicy = "round-robin";
    private String clientID;
    private boolean isFixed = true;
    private byte factoryType = (byte)120;

    public JeusConnectionFactoryCreator() {
    }

    public JeusConnectionFactoryCreator(Reference ref) {
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public void setFactoryClass(Class factoryClass) {
        this.factoryType = factoryClass == QueueConnectionFactory.class ? (byte)81 : (factoryClass == TopicConnectionFactory.class ? (byte)84 : (byte)120);
    }

    public void setMaxThread(int maxSize) {
        this.maxThread = maxSize;
    }

    public void setXASupport(boolean xaSupport) {
        this.xaSupport = xaSupport;
    }

    public void addBrokerAddress(String host, int port) {
        this.brokers.add(new JMSServiceChannelAddress(host, port));
    }

    public void setClientID(String clientID, boolean isFixed) {
        this.clientID = clientID;
        this.isFixed = isFixed;
    }

    public ConnectionFactory createConnectionFactory() throws Exception {
        if (SAF_SERVER_INSTANCE == null && JMSProperties.ENABLE_SAF && this.hasLocalBrokerAddress()) {
            SAF_SERVER_INSTANCE = JMSServer.createSafEngine();
        }
        Reference ref = new Reference("");
        ref.add(new StringRefAddr("factoryName", this.factoryName));
        ref.add((RefAddr)new SerializableRefAddr("type", (Serializable)new Integer(this.factoryType)));
        ref.add((RefAddr)new SerializableRefAddr("maxThread", (Serializable)new Integer(this.maxThread)));
        ref.add((RefAddr)new SerializableRefAddr("xaSupport", (Serializable)(this.xaSupport ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr("xaRecovery", (Serializable)Boolean.FALSE));
        ref.add((RefAddr)new SerializableRefAddr("addresses", (Serializable)this.brokers));
        ref.add(new StringRefAddr("brokerSelectionPolicy", this.brokerSelectionPolicy));
        ref.add(new StringRefAddr("clientID", this.clientID));
        ref.add((RefAddr)new SerializableRefAddr("fixed", (Serializable)(this.isFixed ? Boolean.TRUE : Boolean.FALSE)));
        ref.add((RefAddr)new SerializableRefAddr("sslSupport", (Serializable)Boolean.FALSE));
        return (ConnectionFactory)new ConnectionFactoryOF().getObjectInstance((Object)ref, (Name)null, (Context)null, (Hashtable)null);
    }

    private boolean hasLocalBrokerAddress() {
        for (JMSServiceChannelAddress address : this.brokers) {
            if (!address.getHost().equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS)) continue;
            return true;
        }
        return false;
    }
}

