/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.util.HashSet;
import jeus.jms.common.comm.ActiveStandbyPolicy;
import jeus.jms.common.comm.BrokerSelectionPolicy;
import jeus.jms.common.comm.RoundRobinDedicatedPolicy;
import jeus.jms.common.comm.RoundRobinPolicy;

public class BrokerSelectionPolicyFactory {
    public static final String ROUND_ROBIN_POLICY = "round-robin";
    public static final String ROUND_ROBIN_DEDICATED_POLICY = "round-robin-dedicated";
    public static final String ACTIVE_STANDBY_POLICY = "active-standby";

    public static BrokerSelectionPolicy createBrokerSelectionPolicy(String policyType, HashSet addresses) {
        if (ROUND_ROBIN_POLICY.equals(policyType)) {
            return new RoundRobinPolicy(addresses);
        }
        if (ROUND_ROBIN_DEDICATED_POLICY.equals(policyType)) {
            return new RoundRobinDedicatedPolicy(addresses);
        }
        if (ACTIVE_STANDBY_POLICY.equals(policyType)) {
            return new ActiveStandbyPolicy(addresses);
        }
        throw new IllegalArgumentException("invalid policy type." + policyType);
    }
}

