/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.io.handler.ByteArrayIterator;
import jeus.io.impl.nio.protocol.message.NIOContentWriter;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ByteBufferOutputStream;
import jeus.jms.common.comm.BaseByteArrayIterator;
import jeus.jms.common.message.IntermediateSendMessage;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;

public class JMSNIOContentWriter
extends NIOContentWriter {
    private boolean direct;

    public JMSNIOContentWriter(boolean direct) {
        this.direct = direct;
    }

    public boolean canWriteAsByte(Object toBeWritten) {
        return toBeWritten instanceof MessageContainer;
    }

    public boolean canWritePiggybackDataAsByte(Object piggybackData) {
        return piggybackData instanceof AdminMessage;
    }

    public byte[] getPiggybackDataBuffer(Object piggybackData) throws IOException {
        return MessageFactory.chunkedArrayForWrite((AdminMessage)piggybackData);
    }

    public ByteArrayIterator getBufferAsByte(Object toBeWrite, byte[] header) throws IOException {
        return new IteratorImpl(((MessageContainer)toBeWrite).getWritableMessage(this.direct));
    }

    private class IteratorImpl
    extends BaseByteArrayIterator {
        public IteratorImpl(IntermediateSendMessage message) {
            super(JMSNIOContentWriter.this.direct, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            try {
                ByteBufferOutputStream bbos = new ByteBufferOutputStream(ByteBufferCreator.DEFAULT_BUFFER_SIZE);
                ByteBuffer headerBuffer = bbos.getByteBuffer();
                headerBuffer.put(BYTE_MAGIC_BYTE);
                headerBuffer.position(8);
                headerBuffer = bbos.getByteBuffer();
                int length = 0;
                ByteBuffer[] buffers = new ByteBuffer[this.jeusBuffers.length + 1];
                buffers[0] = headerBuffer;
                for (int i = 0; i < this.jeusBuffers.length; ++i) {
                    ByteBuffer buffer;
                    ByteBufferWrapper wrapper = this.jeusBuffers[i];
                    Object src = wrapper.getSource();
                    if (src instanceof ByteBuffer) {
                        buffer = (ByteBuffer)src;
                        buffers[i + 1] = buffer.isDirect() ? (buffer.isReadOnly() ? buffer.duplicate() : buffer.asReadOnlyBuffer()) : buffer.duplicate();
                    } else {
                        buffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)wrapper.remaining());
                        ByteArray array = wrapper.array();
                        buffer.put(array.getArray(), array.getOffset(), array.getLength());
                        buffer.flip();
                        buffers[i + 1] = buffer;
                    }
                    length += buffers[i + 1].remaining();
                }
                headerBuffer.putInt(4, length);
                headerBuffer.flip();
                ByteBuffer[] byteBufferArray = buffers;
                return byteBufferArray;
            }
            finally {
                this.jeusBuffers = null;
            }
        }
    }
}

