/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.comm.ConnectionState;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.message.ServerMessage;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public abstract class MessageWriter
extends SerialExecutable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    protected JMSRemoteEntry entry;
    private SocketStream stream;
    private ConnectionState state = ConnectionState.ACTIVE;

    public MessageWriter(JMSRemoteEntry entry, SocketStream stream) {
        this.entry = entry;
        this.stream = stream;
    }

    public void setSocketStream(SocketStream stream) {
        if (this.changeState(ConnectionState.ACTIVE)) {
            this.setSuspend(false);
            this.stream = stream;
        }
    }

    public void preExecution(MessageContainer message) {
        if (!message.isRouting() && !message.isExpired() && message.isEOF()) {
            message.messageEvent((byte)4);
        }
        super.preExecution(message);
    }

    public boolean postExecution(MessageContainer packet) {
        return super.postExecution(packet);
    }

    public boolean checkExecutor() {
        return this.isState(ConnectionState.ACTIVE, ConnectionState.CLOSING) && super.checkExecutor();
    }

    public void enqueue(SerialExecutor executor, MessageContainer packet) throws Exception {
        if (packet.isDirect()) {
            this.executeDirect(packet);
        } else {
            this.enqueue(packet);
            this.execute(executor);
        }
    }

    protected abstract void execute(SerialExecutor var1);

    public void enqueue(MessageContainer packet) throws IOException {
        if (this.state == ConnectionState.CLOSED) {
            throw new IOException("Socket is closed");
        }
        this.enqueueWork(packet);
    }

    public void executeDirect(MessageContainer message) throws Exception {
        this.execute(message);
    }

    public void execute(MessageContainer message) throws Exception {
        if (message.isExpired()) {
            this.handleExpired(message);
            return;
        }
        this.handleMessage(message);
    }

    public void handleExpired(MessageContainer message) {
        message.messageEvent((byte)20);
    }

    public void handleMessage(MessageContainer message) throws IOException {
        this.sendMessage(message);
    }

    public void exception(MessageContainer message, JMSException e) {
        message.messageEvent((byte)40);
    }

    public void failed(MessageContainer packet, Throwable t) {
        if (t instanceof EOFException) {
            this.fireCloseEvent((EOFException)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(MessageContainer message) throws IOException {
        if (this.isState(ConnectionState.CLOSED) || this.stream == null) {
            throw new IllegalStateException("Connection is closed.");
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1001_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1001_LEVEL, JeusMessage_JMS1._1001, new Object[]{message, this});
        }
        if (message instanceof ServerMessage && message.getMessageType() == 70) {
            FileMessageImpl fileMsg = (FileMessageImpl)((ServerMessage)message).getClientMessageCopy();
            fileMsg.setURLOnly(false);
            message = fileMsg;
        }
        SocketStream socketStream = this.stream;
        synchronized (socketStream) {
            this.stream.write((Object)message);
        }
    }

    public boolean isCompleted() {
        return this.isEmpty();
    }

    public void fireCloseEvent(Exception e) {
        if (this.connectionClosed()) {
            this.entry.connectionClosed(e);
        }
    }

    public boolean connectionClosed() {
        if (this.changeState(ConnectionState.CLOSED)) {
            this.setSuspend(true);
            this.stream = null;
            return true;
        }
        return false;
    }

    public void prepareShutdown() {
        this.setState(ConnectionState.CLOSING);
    }

    public void shutdown() {
        this.setState(ConnectionState.CLOSED);
        this.setSuspend(true);
        this.stream = null;
    }

    public void flush() {
        this.startExecution();
    }

    public void startRecovery() {
        this.changeState(ConnectionState.RECOVER);
    }

    public void endRecovery() {
        this.changeState(ConnectionState.ACTIVE);
    }

    public void failedRecovery() {
        this.changeState(ConnectionState.CLOSED);
    }

    public synchronized void setState(ConnectionState state) {
        this.state = state;
    }

    public synchronized boolean isState(ConnectionState state) {
        return this.state == state;
    }

    public synchronized boolean isState(ConnectionState status1, ConnectionState status2) {
        return this.state == status1 || this.state == status2;
    }

    public synchronized boolean changeState(ConnectionState change) {
        if (this.state.isChangeableTo(change)) {
            this.state = change;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.entry + "[" + this.entry.getAddress() + "]";
    }
}

