/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.comm;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.comm.BrokerSelectionPolicy;

public class RoundRobinPolicy
extends BrokerSelectionPolicy {
    private JMSServiceChannelAddress[] iteration;
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public RoundRobinPolicy(HashSet addresses) {
        super(addresses);
        this.init();
    }

    private void init() {
        this.iteration = this.addresses.toArray(new JMSServiceChannelAddress[this.addresses.size()]);
    }

    public Enumeration getServiceChannelAddresses() {
        return new ConnectionEnumeration();
    }

    public Enumeration getReconnectServiceChannelAddresses(JMSServiceChannelAddress current) {
        return new ReconnectEnumeration(current);
    }

    public String getBrokerName() {
        return this.iteration[0].getBrokerName();
    }

    public String getType() {
        return "round-robin";
    }

    private class ReconnectEnumeration
    implements Enumeration {
        private JMSServiceChannelAddress[] innerIteration;
        private int count;
        private int index;

        public ReconnectEnumeration(JMSServiceChannelAddress current) {
            HashSet set = new HashSet(RoundRobinPolicy.this.addresses);
            if (set.size() > 1) {
                set.remove(current);
            }
            this.innerIteration = set.toArray(new JMSServiceChannelAddress[set.size()]);
            this.index = RANDOM.nextInt(this.innerIteration.length);
        }

        public boolean hasMoreElements() {
            return this.count < this.innerIteration.length;
        }

        public Object nextElement() {
            ++this.count;
            return this.innerIteration[++this.index % this.innerIteration.length];
        }
    }

    private class ConnectionEnumeration
    implements Enumeration {
        private int index;
        private int count;

        public ConnectionEnumeration() {
            this.index = RANDOM.nextInt(RoundRobinPolicy.this.iteration.length);
        }

        public boolean hasMoreElements() {
            return this.count < RoundRobinPolicy.this.iteration.length;
        }

        public Object nextElement() {
            ++this.count;
            return RoundRobinPolicy.this.iteration[++this.index % RoundRobinPolicy.this.iteration.length];
        }
    }
}

