/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.destination;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.Destination;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.common.destination.JeusTemporaryQueue;
import jeus.jms.common.destination.JeusTemporaryTopic;
import jeus.jms.common.destination.JeusTopic;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.util.ProtocolUtil;

public class DestinationIdentity
implements ISerializable,
Destination,
Serializable {
    private static final long serialVersionUID = 3288398860483353516L;
    public static final String BROKER_NAME = "brokerName";
    public static final String LOCAL_NAME = "localName";
    private byte type;
    private String brokerName;
    private String localName;
    private long tempId = -1L;
    private int tempConnectionId = -1;

    public DestinationIdentity() {
    }

    public DestinationIdentity(byte type) {
        this.type = type;
    }

    public DestinationIdentity(byte type, String brokerName, String name) {
        this.type = type;
        this.brokerName = brokerName;
        this.localName = name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public byte getType() {
        return this.type;
    }

    public long getEntryID() {
        return this.tempId;
    }

    public long getTemporaryID() {
        return this.tempId;
    }

    public void setTemporaryID(long id) {
        this.tempId = id;
    }

    public int getTemporaryConnectionID() {
        return this.tempConnectionId;
    }

    public void setTemporaryConnctionID(int controlInfo) {
        this.tempConnectionId = controlInfo;
    }

    public boolean isTemporary() {
        return this.type == 113 || this.type == 116;
    }

    public void readExternal(DataInput in) throws IOException {
        this.type = in.readByte();
        this.brokerName = ProtocolUtil.readString(in);
        this.localName = ProtocolUtil.readString(in);
        this.tempId = in.readLong();
        this.tempConnectionId = in.readInt();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.type);
        ProtocolUtil.writeString(this.brokerName, out);
        ProtocolUtil.writeString(this.localName, out);
        out.writeLong(this.tempId);
        out.writeInt(this.tempConnectionId);
    }

    public final void readIdentity(DataInput in) throws IOException {
        this.type = in.readByte();
        this.brokerName = ProtocolUtil.readString(in);
        this.localName = ProtocolUtil.readString(in);
        if (this.isTemporary()) {
            this.tempId = in.readLong();
            this.tempConnectionId = in.readInt();
        }
    }

    public final void writeIdentity(DataOutput out) throws IOException {
        out.writeByte(this.getType());
        ProtocolUtil.writeString(this.brokerName, out);
        ProtocolUtil.writeString(this.localName, out);
        if (this.isTemporary()) {
            out.writeLong(this.tempId);
            out.writeInt(this.tempConnectionId);
        }
    }

    public Destination getDestination() {
        DestinationIdentity destination = null;
        switch (this.type) {
            case 81: {
                destination = new JeusQueue(this.brokerName, this.localName);
                break;
            }
            case 84: {
                destination = new JeusTopic(this.brokerName, this.localName);
                break;
            }
            case 113: {
                destination = new JeusTemporaryQueue(this.brokerName, this.localName, this.tempId, this.tempConnectionId);
                break;
            }
            case 116: {
                destination = new JeusTemporaryTopic(this.brokerName, this.localName, this.tempId, this.tempConnectionId);
                break;
            }
            default: {
                return null;
            }
        }
        return destination;
    }

    public String getDestinationType() {
        switch (this.type) {
            case 81: {
                return "Q";
            }
            case 84: {
                return "T";
            }
            case 113: {
                return "TQ";
            }
            case 116: {
                return "TT";
            }
        }
        return "D";
    }

    public int addReferenceInfo(Reference ref) {
        int n = 0;
        ref.add(n++, new StringRefAddr(BROKER_NAME, this.brokerName));
        ref.add(n++, new StringRefAddr(LOCAL_NAME, this.localName));
        return n;
    }

    public int hashCode() {
        return this.localName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DestinationIdentity)) {
            return false;
        }
        DestinationIdentity target = (DestinationIdentity)obj;
        if (this.localName.equals(target.localName)) {
            if (this.brokerName == null && target.brokerName == null) {
                return true;
            }
            if (this.brokerName != null && this.brokerName.equals(target.brokerName)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getDestinationType() + "(" + this.brokerName + ":" + this.localName + ")";
    }
}

