/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.ProtocolUtil;
import jeus.jms.common.util.Utility;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class BytesMessageImpl
extends ClientMessage
implements BytesMessage,
Cloneable {
    private transient ByteArrayOutputStream output = new ByteArrayOutputStream();
    private transient DataOutputStream out = new DataOutputStream(this.output);
    private transient ByteArrayInputStream input;
    private transient DataInputStream in;
    private byte[] data;
    private byte[] oldData;

    public BytesMessageImpl() {
        super((byte)66);
    }

    public BytesMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public Object clone() {
        BytesMessageImpl message = (BytesMessageImpl)this.getMessageClone();
        message.data = this.data == null ? this.output.toByteArray() : this.data;
        return message;
    }

    void marshal(DataOutput out) throws IOException {
        if (this.data == null) {
            this.data = this.output.toByteArray();
        }
        ProtocolUtil.writeBytes(this.data, out);
    }

    void unmarshal(DataInput in) throws IOException {
        this.data = ProtocolUtil.readBytes(in);
    }

    byte[] getData() {
        if (this.data == null) {
            this.data = this.output.toByteArray();
        }
        return this.data;
    }

    void setData(byte[] newData) {
        this.data = newData;
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readBoolean();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public byte readByte() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readByte();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public short readShort() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readShort();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public char readChar() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readChar();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public int readInt() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readInt();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public long readLong() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readLong();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public float readFloat() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readFloat();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public double readDouble() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readDouble();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.read(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeBoolean(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeByte(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeShort(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeChar(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeInt(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeLong(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeFloat(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeDouble(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.write(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.write(value, offset, length);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.checkWriteMode();
        if (value == null) {
            throw new NullPointerException("null object in ByteMessageImpl.writeObject");
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Invalid type");
        }
    }

    public void reset() throws JMSException {
        if (this.data == null) {
            this.data = this.output.toByteArray();
        } else {
            this.input = null;
            this.in = null;
        }
        this.setReadOnlyBody(true);
        this.output = null;
        this.out = null;
    }

    public void clearBody() {
        if (this.oldData != null) {
            this.oldData = this.data;
        }
        this.data = null;
        this.input = null;
        this.in = null;
        this.output = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.output);
        super.clearBody();
    }

    protected void recoverBody() {
        if (this.oldData != null) {
            this.data = this.oldData;
            this.oldData = null;
        }
        this.input = null;
        this.in = null;
    }

    private void checkInputStream() throws JMSException {
        this.checkReadMode();
        if (this.input == null) {
            if (this.data == null) {
                this.data = this.output.toByteArray();
            }
            this.input = new ByteArrayInputStream(this.data);
            this.in = new DataInputStream(this.input);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readUnsignedByte();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readUnsignedShort();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public String readUTF() throws JMSException {
        this.checkReadMode();
        try {
            this.checkInputStream();
            return this.in.readUTF();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4220));
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4221), (Exception)ex);
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkReadMode();
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.checkInputStream();
            return this.in.read(value, 0, length);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4222), (Exception)ex);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWriteMode();
        try {
            this.checkOutputStream();
            this.out.writeUTF(value);
        }
        catch (IOException ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4231), (Exception)ex);
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkReadMode();
        return this.getEstimatedLength();
    }

    public long getEstimatedLength() {
        if (this.data == null) {
            this.data = this.output.toByteArray();
        }
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",bytes={");
        b.append(this.data == null ? "null" : this.data.length + ":: " + Utility.getDump(this.data, 16));
        b.append("}");
        return b.toString();
    }
}

