/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.util.Utility;
import jeus.nio.ByteBufferWrapper;
import jeus.util.ByteArray;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public class IntermediateSendMessage
extends MessageContainer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private ByteBufferWrapper packet;
    protected boolean isAlreadySent;
    protected MessageContainer message;

    public IntermediateSendMessage(ByteBufferWrapper packet, MessageContainer message) {
        super(message.getMetaHeader());
        this.packet = packet;
        this.message = message;
        this.transformer = message.getMessageTransformer();
    }

    public void messageEvent(byte event) {
        this.message.messageEvent(event);
    }

    public boolean isExpired() {
        return this.message.isExpired();
    }

    public String toString() {
        return this.message.toString();
    }

    public synchronized ByteBufferWrapper[] getWritablePacket(boolean direct) throws IOException {
        if (this.isAlreadySent) {
            return null;
        }
        ByteBufferWrapper data = this.checkTransform(direct);
        ByteBufferWrapper header = MessageFactory.serializeForWrite(this.metaHeader, 52, direct);
        int length = header.remaining() + data.remaining();
        header.putInt(4, length);
        this.metaHeader.setTotalLength(length);
        this.isAlreadySent = true;
        return new ByteBufferWrapper[]{header, data};
    }

    private ByteBufferWrapper checkTransform(boolean direct) {
        ByteBufferWrapper data;
        if (this.transformer != null && this.message instanceof UserMessage) {
            byte[] bytes;
            ByteArray byteArray = this.packet.array();
            if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1261_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS1._1261_LEVEL, JeusMessage_JMS1._1261, StringUtil.lineSeparator + Utility.getDump(byteArray));
            }
            if ((bytes = this.transformer.marshal(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength(), (UserMessage)this.message)) != null) {
                if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1262_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS1._1262_LEVEL, JeusMessage_JMS1._1262, StringUtil.lineSeparator + Utility.getDump(bytes));
                }
                data = ByteBufferWrapper.wrap(direct, bytes);
                this.metaHeader.setTransformed(true);
            } else {
                if (JMSProperties.DEBUG_TRANSFORMER && LogUtils.isLoggable(logger, JeusMessage_JMS1._1263_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS1._1263_LEVEL, JeusMessage_JMS1._1263);
                }
                data = this.packet.duplicate();
            }
        } else {
            data = this.packet.duplicate();
        }
        return data;
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(DataInput in) throws IOException {
    }

    public void done() {
        this.isAlreadySent = false;
    }
}

