/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.IOException;
import jeus.jms.MessageTransformer;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.message.IntermediateSendMessage;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MetaHeader;
import jeus.nio.ByteBufferWrapper;

public abstract class MessageContainer
implements ISerializable {
    protected final MetaHeader metaHeader;
    protected MessageTransformer transformer;

    protected MessageContainer() {
        this.metaHeader = new MetaHeader();
    }

    protected MessageContainer(MetaHeader metaHeader) {
        this.metaHeader = metaHeader;
    }

    public void setMessageTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    public MessageTransformer getMessageTransformer() {
        return this.transformer;
    }

    public void recover(short brokerID, long entryID) {
        this.setBrokerID(brokerID);
        this.setEntryID(entryID);
    }

    public void messageEvent(byte event) {
    }

    public boolean isExpired() {
        return false;
    }

    public synchronized IntermediateSendMessage getWritableMessage(boolean direct) throws IOException {
        ByteBufferWrapper buffer = MessageFactory.serializeForWrite(this, direct);
        return this.createIntermediateMessage(buffer);
    }

    protected IntermediateSendMessage createIntermediateMessage(ByteBufferWrapper buffer) {
        return new IntermediateSendMessage(buffer, this);
    }

    public boolean isXAExecutable() {
        return false;
    }

    public MetaHeader getMetaHeader() {
        return this.metaHeader;
    }

    public int getTotalLength() {
        return this.metaHeader.getTotalLength();
    }

    public boolean isSetBroker() {
        return this.metaHeader.isSetBroker();
    }

    public short getBrokerID() {
        return this.metaHeader.getBrokerID();
    }

    public void setBrokerID(short entryID) {
        this.metaHeader.setBrokerID(entryID);
    }

    public byte getTargetID() {
        return this.metaHeader.getTargetID();
    }

    public byte getLocalTargetID() {
        return this.metaHeader.getLocalTargetID();
    }

    public void setTargetID(byte targetID) {
        this.metaHeader.setTargetID(targetID);
    }

    public long getEntryID() {
        return this.metaHeader.getEntryID();
    }

    public void setEntryID(long entryID) {
        this.metaHeader.setEntryID(entryID);
    }

    public int getConnectionID() {
        return this.metaHeader.getConnectionID();
    }

    public void setConnectionID(int connectionID) {
        this.metaHeader.setConnectionID(connectionID);
    }

    public int getSessionID() {
        return this.metaHeader.getSessionID();
    }

    public void setSessionID(int id) {
        this.metaHeader.setSessionID(id);
    }

    public int getConsumerID() {
        return this.metaHeader.getConsumerID();
    }

    public void setConsumerID(int id) {
        this.metaHeader.setConsumerID(id);
    }

    public int getProducerID() {
        return this.metaHeader.getProducerID();
    }

    public void setProducerID(int id) {
        this.metaHeader.setProducerID(id);
    }

    public boolean isAdminMessage() {
        return this.metaHeader.isAdminMessage();
    }

    public boolean isAgency() {
        return this.metaHeader.isAgency();
    }

    public void setAgency() {
        this.metaHeader.setAgency();
    }

    public boolean isRecovered() {
        return this.metaHeader.isRecovered();
    }

    public void setRecovered(boolean recovered) {
        this.metaHeader.setRecovered(recovered);
    }

    public boolean isDirect() {
        return this.metaHeader.isDirect();
    }

    public void setDirect(boolean direct) {
        this.metaHeader.setDirect(direct);
    }

    public boolean isDelayed() {
        return this.metaHeader.isDelayed();
    }

    public void setDelayed(boolean delayed) {
        this.metaHeader.setDelayed(delayed);
    }

    public boolean isLocalConsume() {
        return this.metaHeader.isLocalConsume();
    }

    public void setLocalConsume(boolean localConsume) {
        this.metaHeader.setLocalConsume(localConsume);
    }

    public short getGroupID() {
        return this.metaHeader.getGroupID();
    }

    public void setGroupID(short groupID) {
        this.metaHeader.setGroupID(groupID);
    }

    public int getGroupSequence() {
        return this.metaHeader.getGroupSequence();
    }

    public void setGroupSequence(int groupSeq) {
        this.metaHeader.setGroupSequence(groupSeq);
    }

    public boolean isGroupedMessage() {
        return this.metaHeader.isGroupedMessage();
    }

    public void setGroupEOF() {
        this.metaHeader.setGroupEOF();
    }

    public boolean isGroupEOF() {
        return this.metaHeader.isGroupEOF();
    }

    public short getPartialID() {
        return this.metaHeader.getPartialID();
    }

    public void setPartialID(short partialID) {
        this.metaHeader.setPartialID(partialID);
    }

    public int getPartialSequence() {
        return this.metaHeader.getPartialSequence();
    }

    public void setPartialSequence(int sequence) {
        this.metaHeader.setPartialSequence(sequence);
    }

    public boolean isPartialMessage() {
        return this.metaHeader.isPartialMessage();
    }

    public void setPartialEOF() {
        this.metaHeader.setPartialEOF();
    }

    public boolean isPartialEOF() {
        return this.metaHeader.isPartialEOF();
    }

    public boolean isEOF() {
        return this.metaHeader.isEOF();
    }

    public byte getMessageType() {
        return this.metaHeader.getMessageType();
    }

    public int getObserverID() {
        return this.metaHeader.getObserverID();
    }

    public void setObserverID(int id) {
        this.metaHeader.setObserverID(id);
    }

    public void setRequestFlag(boolean request) {
        this.metaHeader.setRequestFlag(request);
    }

    public void setObserved(boolean observe) {
        this.metaHeader.setObserved(observe);
    }

    public boolean isNotifyMessage() {
        return this.metaHeader.isNotifyMessage();
    }

    public boolean isRequestMessage() {
        return this.metaHeader.isRequestMessage();
    }

    public boolean isReplyMessage() {
        return this.metaHeader.isReplyMessage();
    }

    public boolean isRouting() {
        return this.metaHeader.isRouting();
    }

    public boolean isServerRouting() {
        return this.metaHeader.isServerRouting();
    }

    public void setServerRouting(boolean flag) {
        this.metaHeader.setServerRouting(flag);
    }

    public boolean isClientRouting() {
        return this.metaHeader.isClientRouting();
    }

    public void setClientRouting(boolean flag) {
        this.metaHeader.setClientRouting(flag);
    }

    public String toString() {
        return this.metaHeader.toString();
    }

    public String dumpString() {
        StringBuffer buf = new StringBuffer("MessageContainer[metaHeader=");
        buf.append(this.metaHeader.dumpString());
        buf.append("]");
        return buf.toString();
    }
}

