/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.Destination;
import jeus.jms.common.destination.DestinationFactory;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.util.ProtocolUtil;

public class MessageHeader
implements ISerializable,
Cloneable {
    public static final int TIMESTAMP_FLAG = 1;
    public static final int EXPIRE_FLAG = 2;
    public static final int SCHEDULE_FLAG = 4;
    private String correlationID;
    private DestinationIdentity replyTo;
    private DestinationIdentity destination;
    private int deliveryMode = 2;
    private String jmsType;
    private long expiration;
    private int priority;
    private int metaInfo;
    private long schedule;
    private long timestamp;

    public MessageHeader() {
    }

    public MessageHeader(DataInput in) throws IOException {
        this.readExternal(in);
    }

    public void readExternal(DataInput in) throws IOException {
        this.correlationID = ProtocolUtil.readString(in);
        this.destination = DestinationFactory.readDestination(in);
        this.replyTo = DestinationFactory.readDestination(in);
        this.deliveryMode = in.readInt();
        this.jmsType = ProtocolUtil.readString(in);
        this.priority = in.readInt();
        this.metaInfo = in.readInt();
        if (this.isExpire()) {
            this.expiration = in.readLong();
        }
        if (this.isTimestamped()) {
            this.timestamp = in.readLong();
        }
        if (this.isScheduled()) {
            this.schedule = in.readLong();
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ProtocolUtil.writeString(this.correlationID, out);
        DestinationFactory.writeDestination(this.destination, out);
        DestinationFactory.writeDestination(this.replyTo, out);
        out.writeInt(this.deliveryMode);
        ProtocolUtil.writeString(this.jmsType, out);
        out.writeInt(this.priority);
        out.writeInt(this.metaInfo);
        if (this.isExpire()) {
            out.writeLong(this.expiration);
        }
        if (this.isTimestamped()) {
            out.writeLong(this.timestamp);
        }
        if (this.isScheduled()) {
            out.writeLong(this.schedule);
        }
    }

    public void setJMSMessageID(String id) {
    }

    public long getJMSTimestamp() {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setValue(1, timestamp != 0L);
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationID == null ? null : this.correlationID.getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.correlationID = new String(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    public String getJMSCorrelationID() {
        return this.correlationID;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo == null ? null : this.replyTo.getDestination();
    }

    public Destination getReplyTo() {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.replyTo = (DestinationIdentity)replyTo;
    }

    public Destination getJMSDestination() {
        return this.destination == null ? null : this.destination.getDestination();
    }

    public DestinationIdentity getDestination() {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) {
        this.destination = (DestinationIdentity)destination;
    }

    public void setDestination(DestinationIdentity destination) {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String type) {
        this.jmsType = type;
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) {
        if (expiration != 0L) {
            expiration += this.isTimestamped() ? this.timestamp : System.currentTimeMillis();
        }
        this.expiration = expiration;
        this.setValue(2, expiration != 0L);
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public void setJMSPriority(int priority) {
        this.priority = priority;
    }

    public boolean isTimestamped() {
        return this.isSet(1);
    }

    public boolean isScheduled() {
        return this.isSet(4);
    }

    public void setScheduled(boolean scheduled) {
        this.setValue(4, scheduled);
    }

    public boolean isExpire() {
        return this.isSet(2);
    }

    public long getScheduledTime() {
        return this.schedule;
    }

    public void setScheduledTime(long schedule) {
        this.schedule = schedule;
        this.setScheduled(schedule != 0L);
    }

    private void setValue(int flag, boolean set) {
        this.metaInfo = set ? (this.metaInfo |= flag) : (this.metaInfo &= ~flag);
    }

    private boolean isSet(int flag) {
        return (this.metaInfo & flag) != 0;
    }

    public int getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(int metaInfo) {
        this.metaInfo = metaInfo;
    }

    public MessageHeader getClone() {
        MessageHeader clone = new MessageHeader();
        clone.correlationID = this.correlationID;
        clone.replyTo = this.replyTo;
        clone.destination = this.destination;
        clone.deliveryMode = this.deliveryMode;
        clone.jmsType = this.jmsType;
        clone.expiration = this.expiration;
        clone.priority = this.priority;
        clone.timestamp = this.timestamp;
        clone.metaInfo = this.metaInfo;
        clone.timestamp = this.timestamp;
        return clone;
    }
}

