/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import jeus.jms.common.message.ISerializable;

public class MessageID
implements Cloneable,
ISerializable {
    private static final String PREFIX = "ID";
    private static final String DELIMITER = ":";
    public static final byte PERSISTED = 1;
    public static final byte TRANSACTED = 2;
    public static final byte CONSUMED = 4;
    public static final byte POISONED = 8;
    public static final int KEY_SIZE = 19;
    public static final MessageID NULL = new MessageID(0, 0L, 0, 0);
    private byte status;
    private short brokerID;
    private long entryID;
    private int connectionID;
    private int sequence;
    private transient String messageID;

    public MessageID(short brokerID, long entryID, int connectinID, int sequence) {
        this.brokerID = brokerID;
        this.entryID = entryID;
        this.connectionID = connectinID;
        this.sequence = sequence;
        this.setJMSMessageID();
    }

    public MessageID(DataInput in) throws IOException {
        this.readExternal(in);
        this.setJMSMessageID();
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public short getBrokerID() {
        return this.brokerID;
    }

    public long getEntryID() {
        return this.entryID;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getSequenceNumber() {
        return this.sequence;
    }

    private void setJMSMessageID() {
        this.messageID = "ID:" + this.brokerID + DELIMITER + this.entryID + DELIMITER + this.connectionID + DELIMITER + this.sequence;
    }

    public String getJMSMessageID() {
        return this.messageID;
    }

    public boolean isPersisted() {
        return this.isSet((byte)1);
    }

    public void setPersisted(boolean persisted) {
        this.setValue((byte)1, persisted);
    }

    public boolean isTransacted() {
        return this.isSet((byte)2);
    }

    public void setTransacted(boolean transacted) {
        this.setValue((byte)2, transacted);
    }

    public boolean isConsumed() {
        return this.isSet((byte)4);
    }

    public void setConsumed(boolean consumed) {
        this.setValue((byte)4, consumed);
    }

    public boolean isPoisoned() {
        return this.isSet((byte)8);
    }

    public void setPoisoned(boolean poisoned) {
        this.setValue((byte)8, poisoned);
    }

    private void setValue(byte mask, boolean value) {
        this.status = value ? (byte)(this.status | mask) : (byte)(this.status & ~mask);
    }

    private boolean isSet(byte mask) {
        return (this.status & mask) != 0;
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.status);
        out.writeShort(this.brokerID);
        out.writeLong(this.entryID);
        out.writeInt(this.connectionID);
        out.writeInt(this.sequence);
    }

    public void readExternal(DataInput in) throws IOException {
        this.status = in.readByte();
        this.brokerID = in.readShort();
        this.entryID = in.readLong();
        this.connectionID = in.readInt();
        this.sequence = in.readInt();
    }

    public MessageID getClone() {
        MessageID messageID = new MessageID(this.brokerID, this.entryID, this.connectionID, this.sequence);
        messageID.status = this.status;
        return messageID;
    }

    public MessageID recreate(short brokerID, long entryID) {
        MessageID messageID = new MessageID(brokerID, entryID, this.connectionID, this.sequence);
        messageID.status = this.status;
        return messageID;
    }

    public boolean equals(Object another) {
        if (!(another instanceof MessageID)) {
            return false;
        }
        MessageID id = (MessageID)another;
        return id.brokerID == this.brokerID && id.entryID == this.entryID && id.connectionID == this.connectionID && id.sequence == this.sequence;
    }

    public int hashCode() {
        return this.messageID.hashCode();
    }

    public String toString() {
        return this.messageID;
    }

    public static MessageID parseMessageID(String messageID) throws JMSException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(messageID, DELIMITER);
            String id = tokenizer.nextToken();
            if (!PREFIX.equals(id)) {
                throw new JMSException("invalid message id " + messageID);
            }
            short brokerID = Short.parseShort(tokenizer.nextToken());
            long entryID = Long.parseLong(tokenizer.nextToken());
            int connectionID = Integer.parseInt(tokenizer.nextToken());
            int sequence = Integer.parseInt(tokenizer.nextToken());
            return new MessageID(brokerID, entryID, connectionID, sequence);
        }
        catch (Throwable t) {
            throw new JMSException("invalid message id " + messageID);
        }
    }
}

