/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.ProtocolUtil;

public class TextMessageImpl
extends ClientMessage
implements TextMessage,
Cloneable {
    private String text;
    private String oldText;

    public TextMessageImpl() {
        super((byte)84);
    }

    public TextMessageImpl(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public TextMessageImpl(String text) {
        super((byte)84);
        this.text = text;
    }

    public Object clone() {
        TextMessageImpl message = (TextMessageImpl)this.getMessageClone();
        message.text = this.text;
        return message;
    }

    void marshal(DataOutput out) throws IOException {
        ProtocolUtil.writeStringLong(this.text, out);
    }

    void unmarshal(DataInput in) throws IOException {
        this.text = ProtocolUtil.readStringLong(in);
    }

    public void setText(String string) throws JMSException {
        this.checkOutputStream();
        this.text = string;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public void clearBody() {
        if (this.oldText == null) {
            this.oldText = this.text;
        }
        this.text = null;
        super.clearBody();
    }

    protected void recoverBody() {
        if (this.oldText != null) {
            this.text = this.oldText;
            this.oldText = null;
        }
    }

    public long getEstimatedLength() {
        return this.text == null ? 0L : (long)this.text.length();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",text={");
        b.append(this.text == null ? "null" : "(0x" + Integer.toHexString(this.text.length()) + "b)" + (this.text.length() > 48 ? this.text.substring(0, 48) + "...." : this.text));
        b.append("}");
        return b.toString();
    }
}

