/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CallBackAddressMessage
extends AdminMessage {
    private String ipAddress;
    private int port;
    private int entryID;
    private boolean reconnect;

    public CallBackAddressMessage() {
        super((byte)20);
    }

    public CallBackAddressMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)20);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setPeerEntryID(int entryID) {
        this.entryID = entryID;
    }

    public int getPeerEntryID() {
        return this.entryID;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public boolean getReconnect() {
        return this.reconnect;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.ipAddress = ProtocolUtil.readString(in);
        this.port = in.readInt();
        this.entryID = in.readInt();
        this.reconnect = in.readBoolean();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.ipAddress, out);
        out.writeInt(this.port);
        out.writeInt(this.entryID);
        out.writeBoolean(this.reconnect);
    }
}

