/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.PublicAdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CleanUpQueueMessage
extends PublicAdminMessage {
    private String queueName;

    public CleanUpQueueMessage() {
    }

    public CleanUpQueueMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)-2);
    }

    public CleanUpQueueMessage(String queueName) {
        super((byte)-2);
        this.queueName = queueName;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.queueName = ProtocolUtil.readString(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.queueName, out);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",queue name=").append(this.queueName);
        return b.toString();
    }
}

