/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class CreateProducerMessage
extends AdminMessage {
    private String destination;
    private int producerID;
    private boolean bidirectional;
    private boolean durable;

    public CreateProducerMessage(String destination) {
        super((byte)10);
        this.destination = destination;
        this.setTargetID((byte)15);
    }

    public CreateProducerMessage(DestinationIdentity destination) {
        this(destination == null ? null : destination.getLocalName());
    }

    public CreateProducerMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)10);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setAssignedProducerID(int producerID) {
        this.producerID = producerID;
    }

    public int getAssignedProducerID() {
        return this.producerID;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.destination = ProtocolUtil.readString(in);
        this.producerID = in.readInt();
        this.bidirectional = in.readBoolean();
        this.durable = in.readBoolean();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.destination, out);
        out.writeInt(this.producerID);
        out.writeBoolean(this.bidirectional);
        out.writeBoolean(this.durable);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",producerID={").append(this.producerID).append('}');
        b.append(",destination={").append(this.destination).append('}');
        b.append(",cluster{").append(this.bidirectional).append(',').append(this.durable).append('}');
        return b.toString();
    }
}

