/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class DeliveryCountMessage
extends AdminMessage {
    private String destName;
    private long deliveryCount;

    public DeliveryCountMessage() {
        super((byte)25);
        this.setTargetID((byte)15);
    }

    public DeliveryCountMessage(String destName) {
        super((byte)25);
        this.destName = destName;
        this.setTargetID((byte)15);
    }

    public DeliveryCountMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)25);
    }

    public String getDestName() {
        return this.destName;
    }

    public void setDeliveryCount(long deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public long getDeliveryCount() {
        return this.deliveryCount;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.destName = ProtocolUtil.readString(in);
        this.deliveryCount = in.readLong();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.destName, out);
        out.writeLong(this.deliveryCount);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",{");
        b.append(",destName={").append(this.destName).append('}');
        b.append(",deliveryCount={").append(this.deliveryCount).append('}');
        b.append("}");
        return b.toString();
    }
}

