/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.MessageHandleEvent;

public class MultipleMessageHandleEvent
extends MessageHandleEvent {
    private List messages;
    private transient List messageIDs;
    private transient boolean remote;

    public MultipleMessageHandleEvent(byte opcode) {
        super(opcode);
    }

    public MultipleMessageHandleEvent(byte opcode, MetaHeader metaHeader, List messages) {
        super(metaHeader, opcode);
        this.messages = messages;
    }

    public MultipleMessageHandleEvent(MetaHeader metaHeader, byte opcode) {
        super(metaHeader, opcode);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public ListIterator getMessageIterator() {
        return new MessageIterator(false);
    }

    public ListIterator getInverseMessageIterator() {
        return new MessageIterator(true);
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.readMessageIDs(in);
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        this.writeMessageIDs(out);
    }

    private void writeMessageIDs(DataOutput out) throws IOException {
        out.writeInt(this.messages.size());
        for (ClientMessage message : this.messages) {
            MessageID messageID = message.getMessageID();
            messageID.writeExternal(out);
        }
    }

    private void readMessageIDs(DataInput in) throws IOException {
        this.messageIDs = new LinkedList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MessageID messageID = new MessageID(in);
            this.messageIDs.add(messageID);
        }
        this.remote = true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString()).append(',').append(this.isTransacted() ? "TRANSACTED" : "");
        b.append(",message list={");
        ListIterator it = this.getMessageIterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append(',');
        }
        b.append("}");
        return b.toString();
    }

    private class MessageIterator
    implements ListIterator {
        private ListIterator it;

        MessageIterator(boolean inverse) {
            this.it = inverse ? (MultipleMessageHandleEvent.this.remote ? MultipleMessageHandleEvent.this.messageIDs.listIterator(MultipleMessageHandleEvent.this.messageIDs.size()) : MultipleMessageHandleEvent.this.messages.listIterator(MultipleMessageHandleEvent.this.messages.size())) : (MultipleMessageHandleEvent.this.remote ? MultipleMessageHandleEvent.this.messageIDs.listIterator() : MultipleMessageHandleEvent.this.messages.listIterator());
        }

        public int nextIndex() {
            return this.it.nextIndex();
        }

        public int previousIndex() {
            return this.it.previousIndex();
        }

        public void remove() {
            this.it.remove();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return MultipleMessageHandleEvent.this.remote ? this.it.next() : ((ClientMessage)this.it.next()).getMessageID();
        }

        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        public Object previous() {
            return MultipleMessageHandleEvent.this.remote ? this.it.previous() : ((ClientMessage)this.it.previous()).getMessageID();
        }

        public void add(Object o) {
            this.it.add(o);
        }

        public void set(Object o) {
            this.it.set(o);
        }
    }
}

