/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.ProtocolUtil;

public class RequestConsumerCountMessage
extends AdminMessage {
    private String topicName;
    private int consumerCount;

    public RequestConsumerCountMessage() {
        super((byte)24);
        this.setTargetID((byte)15);
    }

    public RequestConsumerCountMessage(String topicName) {
        super((byte)24);
        this.topicName = topicName;
        this.setTargetID((byte)15);
    }

    public RequestConsumerCountMessage(MetaHeader metaHeader) {
        super(metaHeader, (byte)24);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public boolean checkActiveConsumer() {
        return !this.getBooleanFlag();
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void readBody(DataInput in) throws IOException {
        super.readBody(in);
        this.topicName = ProtocolUtil.readString(in);
        this.consumerCount = in.readInt();
    }

    public void writeBody(DataOutput out) throws IOException {
        super.writeBody(out);
        ProtocolUtil.writeString(this.topicName, out);
        out.writeInt(this.consumerCount);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        b.append(",{");
        b.append(",topicName={").append(this.topicName).append('}');
        b.append(",consumerCount={").append(this.consumerCount).append('}');
        b.append("}");
        return b.toString();
    }
}

