/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.selector;

import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.selector.BinaryExpression;
import jeus.jms.common.message.selector.BooleanExpression;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(UserMessage message) {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(UserMessage message) {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public abstract Object evaluate(UserMessage var1);

    public boolean matches(UserMessage message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }
}

