/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.message.selector;

import java.util.HashMap;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.selector.Expression;

public class PropertyExpression
implements Expression {
    private final String name;
    private final SubExpression jmsPropertyExpression;
    private static final HashMap JMS_PROPERTY_EXPRESSIONS = new HashMap();

    public PropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = (SubExpression)JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    public Object evaluate(UserMessage message) {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        if (message.getProperties() == null) {
            return null;
        }
        return message.getProperties().get(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return message.getJMSType();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Integer(message.isPersistent() ? 2 : 1);
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Integer(message.getJMSPriority());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", new SubExpression(){

            public Object evaluate(UserMessage message) {
                if (message.getJMSMessageID() == null) {
                    return null;
                }
                return message.getJMSMessageID();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Long(message.getJMSTimestamp());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return message.getJMSCorrelationID();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXDeliveryCount", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Integer(message.getDeliveryCount());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXGroupID", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Short(message.getGroupID());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXGroupSeq", new SubExpression(){

            public Object evaluate(UserMessage message) {
                return new Integer(message.getGroupSequence());
            }
        });
    }

    static interface SubExpression {
        public Object evaluate(UserMessage var1);
    }
}

