/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import jeus.jms.client.facility.MessageEventProvider;
import jeus.jms.client.facility.consumer.ClientMessageQueue;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS1;

public class AcknowledgeManager {
    private int lastCommitIndex;
    private LinkedList consumedList;
    private ClientMessageQueue source;
    private int sessionID;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public AcknowledgeManager(int sessionID, ClientMessageQueue source) {
        this.sessionID = sessionID;
        this.source = source;
        this.consumedList = new LinkedList();
    }

    public void messageConsuming(int ackmode, ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1121_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1121_LEVEL, JeusMessage_JMS1._1121, new Object[]{message.getMessageID(), this.source, new Integer(ackmode)});
        }
        this.consumedList.add(message);
    }

    public void onMessage(MessageListener listener, ClientMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1122_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1122_LEVEL, JeusMessage_JMS1._1122, new Object[]{message.getMessageID(), this.source, listener.getClass()});
        }
    }

    public void messageConsumed(int ackmode, ClientMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1123_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1123_LEVEL, JeusMessage_JMS1._1123, new Object[]{message.getMessageID(), this.source, this, new Integer(ackmode)});
        }
        switch (ackmode) {
            case -1: 
            case 1: 
            case 3: {
                if (!this.consumedList.remove(message) || ackmode == -1 && message.getMessageType() != 70) break;
                this.acknowledge(message, ackmode == 3);
                break;
            }
        }
    }

    public void handleRuntimeException(int ackmode, RuntimeException re, ClientMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1124_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1124_LEVEL, JeusMessage_JMS1._1124, new Object[]{message.getMessageID(), this.source, this});
        }
        switch (ackmode) {
            case -1: 
            case 1: 
            case 3: {
                if (ackmode != -1 || message.getMessageType() == 70) {
                    if (this.consumedList.remove(message) && message.getDeliveryCount() <= message.getRedeliveryLimit()) {
                        this.source.recover((MessageEventProvider)this.source, message);
                        break;
                    }
                    MessageHandleEvent event = MessageUtil.createEventMessage((byte)52, message);
                    this.source.sendNotifyMessage(event);
                    break;
                }
            }
            case 0: 
            case 2: {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS1._1125_LEVEL)) break;
                LogUtils.log(logger, JeusMessage_JMS1._1125_LEVEL, JeusMessage_JMS1._1125, message, (Throwable)re);
            }
        }
    }

    private void acknowledge(ClientMessage message, boolean delayed) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1126_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1126_LEVEL, JeusMessage_JMS1._1126, new Object[]{message.getMessageID(), this.source});
        }
        MessageHandleEvent event = this.source.createMessageEvent((byte)50, message);
        event.setDelayed(delayed);
        this.notifyEvent(event);
    }

    public void acknowledge(boolean transacted) throws JMSException {
        if (this.lastCommitIndex >= this.consumedList.size()) {
            return;
        }
        List target = this.consumedList.subList(this.lastCommitIndex, this.consumedList.size());
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1127_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1127_LEVEL, JeusMessage_JMS1._1127, new Object[]{this.getMessageIDs(target), this.source, transacted ? "transacted" : "not transacted"});
        }
        MessageHandleEvent event = this.source.createMessageEvent((byte)50, target);
        event.setTransacted(transacted);
        this.notifyEvent(event);
        this.clearConsumed(transacted);
    }

    public void recoverLocal() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1128_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1128_LEVEL, JeusMessage_JMS1._1128, new Object[]{this.getMessageIDs(this.consumedList), this.source});
        }
        this.source.recover((MessageEventProvider)this.source, this.consumedList);
        this.clearConsumed(false);
    }

    public void recoverRemote() throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1129_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1129_LEVEL, JeusMessage_JMS1._1129, new Object[]{this.getMessageIDs(this.consumedList), this.source});
        }
        if (this.lastCommitIndex == 0) {
            MessageHandleEvent event = this.source.createMessageEvent((byte)49, this.consumedList);
            this.notifyEvent(event);
        }
        this.clearConsumed(false);
    }

    public void clearConsumed(boolean transacted) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS1._1130_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS1._1130_LEVEL, JeusMessage_JMS1._1130, new Object[]{this.source, this, transacted ? "transacted" : "not transacted"});
        }
        if (transacted) {
            this.lastCommitIndex = this.consumedList.size();
        } else {
            this.consumedList.clear();
            this.lastCommitIndex = 0;
        }
    }

    public boolean isEmpty() {
        return this.consumedList.isEmpty();
    }

    private void notifyEvent(MessageHandleEvent event) throws JMSException {
        event.setSessionID(this.sessionID);
        this.source.sendNotifyMessage(event);
    }

    private String getMessageIDs(List consumed) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = consumed.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            ClientMessage o = (ClientMessage)i.next();
            buf.append(o.getMessageID());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString() {
        return this.getMessageIDs(this.consumedList);
    }
}

