/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import jeus.jms.common.pool.ManagedServerSessionPool;
import jeus.util.concurrent.Channel;
import jeus.util.concurrent.LinkedQueue;
import jeus.util.concurrent.PooledExecutor;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.concurrent.ThreadFactory;

public class JMSPooledExecutor
extends PooledExecutor {
    private ManagedServerSessionPool pool;

    public JMSPooledExecutor(String prefix, int maxPoolSize, boolean daemon) {
        super((Channel)new LinkedQueue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean offer(Object x, long msecs) throws InterruptedException {
                Object object = this.putLock_;
                synchronized (object) {
                    return this.waitingForTake_ > 0 && super.offer(x, msecs);
                }
            }
        }, maxPoolSize);
        this.setThreadFactory(new JMSThreadFactory(prefix, daemon));
        this.setBlockedExecutionHandler(new BlockedHandler());
    }

    public void setInitPoolSize(int initPoolSize) {
        this.createThreads(initPoolSize);
    }

    public void shutdown() {
        this.shutdownNow();
    }

    public int getRunningThreadCount() {
        return this.getPoolSize() - this.getWaitingCount();
    }

    public int getTotalThreadCount() {
        return this.getPoolSize();
    }

    protected void workerDone(Runnable worker) {
        super.workerDone(worker);
        this.notifyEvent();
    }

    private void notifyEvent() {
        if (this.pool == null) {
            return;
        }
        this.pool.threadRemoved();
    }

    public void setEventListener(ManagedServerSessionPool pool) {
        this.pool = pool;
    }

    private class BlockedHandler
    implements PooledExecutor.BlockedExecutionHandler {
        private BlockedHandler() {
        }

        public boolean blockedAction(Runnable command) throws InterruptedException {
            JMSPooledExecutor.this.handOff_.put((Object)command);
            return true;
        }
    }

    private class JMSThreadFactory
    implements ThreadFactory {
        private SynchronizedInt sequencer;
        private String prefix;
        private boolean daemon;

        public JMSThreadFactory(String prefix, boolean daemon) {
            this.prefix = prefix;
            this.daemon = daemon;
            this.sequencer = new SynchronizedInt(0);
        }

        public Thread newThread(Runnable command) {
            Thread thread = new Thread(command, this.prefix + "-" + this.sequencer.increment());
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

