/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.common.util;

import java.io.UnsupportedEncodingException;
import jeus.jms.common.util.DataSqueezer;
import jeus.jms.common.util.SqueezeAdaptor;
import jeus.security.util.Base64Util;

public class StringAdaptor
implements SqueezeAdaptor {
    private static final String PREFIX = "S";

    public String getPrefix() {
        return PREFIX;
    }

    public Class getDataClass() {
        return String.class;
    }

    public String squeeze(DataSqueezer squeezer, Object data) {
        String string = (String)data;
        try {
            return PREFIX + Base64Util.tob64((byte[])string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object unsqueeze(DataSqueezer squeezer, String string) {
        if (string.length() == 1) {
            return "";
        }
        try {
            return new String(Base64Util.fromb64((String)string.substring(1)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

