/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.List;
import javax.jms.JMSException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSDurableSubscriberResourceMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;

public class JMSDurableCommand
extends JMSCommand {
    private Argument durableArg = new Argument("durable_name", "durable subscription name");
    private Option messageOption;
    private OptionalArgument selectorOrMsgIDArg;

    public JMSDurableCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "durable", "print destination information", utility, container);
        this.registerArgument(this.durableArg);
        this.messageOption = new Option("m", "includes message information");
        this.registerArgument((Argument)this.messageOption);
        this.selectorOrMsgIDArg = new OptionalArgument("selector", "message selector for message browsing");
        this.registerArgument((Argument)this.selectorOrMsgIDArg);
    }

    public void run(PrintStream out) throws Exception {
        out.println("====<<Durable Subscription Info>>====");
        String _durableName = this.durableArg.getValue();
        ObjectName[] names = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSDurableSubscriberResource", (String)_durableName);
        if (names == null || names.length == 0) {
            out.println("<No Durable Subscription was found>");
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            JMSDurableSubscriberResourceMBean durableMbean = (JMSDurableSubscriberResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)name, JMSDurableSubscriberResourceMBean.class, (boolean)false);
            this.showDurableSubscriber(durableMbean, this.messageOption.isSet(), this.selectorOrMsgIDArg.getValue(), out);
        }
    }

    public void showDurableSubscriber(JMSDurableSubscriberResourceMBean durableMbean, boolean showMessageInfo, String selector, PrintStream out) throws JMSException {
        this.directLogWithSpace("Durable Subsciption:", out);
        this.directLogWithSpace("Durable Name:" + durableMbean.getDurableName(), out);
        this.directLogWithSpace("ClientID:" + durableMbean.getClientID(), out);
        this.directLogWithSpace("Selector:" + durableMbean.getSelector(), out);
        this.directLogWithSpace("Remaining messages count:" + durableMbean.getRemainingMessages(), out);
        if (showMessageInfo) {
            List messageInfos = durableMbean.getMessageInfo(selector);
            this.showMessageInfo(messageInfos, out);
        }
    }
}

