/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSClientEntryInfo;
import jeus.jms.server.mbean.JMSServiceChannelMoMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.Option;

public class JMSEntryAllCommand
extends JMSCommand {
    private static Date TEMP_DATE = new Date();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    private final Option detailedOption = new Option("d", "in detail", true);

    public JMSEntryAllCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "entryall", "lists all entries", utility, container);
        this.registerArgument((Argument)this.detailedOption);
    }

    public void run(PrintStream out) throws Exception {
        ObjectName[] resources = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSServiceChannel", null);
        if (resources == null) {
            this.directLogWithSpace("No jms server resource was found", out);
            return;
        }
        if (this.detailedOption.isSet()) {
            out.println("====================================================================");
            out.println("Detailed information for all entries");
            out.println("--------------------------------------------------------------------");
            out.println("  Entry name          Connected time           IP address");
            out.println("--------------------------------------------------------------------");
        } else {
            out.println("====<<Entry>>====");
        }
        int totalNumOfEntries = 0;
        for (int i = 0; i < resources.length; ++i) {
            ObjectName name = resources[i];
            JMSServiceChannelMoMBean jmsMbean = (JMSServiceChannelMoMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)name, JMSServiceChannelMoMBean.class, (boolean)false);
            if (this.detailedOption.isSet()) {
                JMSClientEntryInfo[] clientsEntryInfo = jmsMbean.getDetailedClientsInfo();
                this.showEntryInformation(clientsEntryInfo, out);
                if (clientsEntryInfo.length != 0) {
                    out.println("--------------------------------------------------------------------");
                }
                totalNumOfEntries += clientsEntryInfo.length;
                continue;
            }
            String[] entryNames = jmsMbean.getJMSClientResourceNames();
            if (entryNames == null) continue;
            if (entryNames.length != 0) {
                this.printSortedName(entryNames, out);
                out.println("-----------------");
            }
            totalNumOfEntries += entryNames.length;
        }
        out.println("Num of entries: " + totalNumOfEntries);
    }

    private void showEntryInformation(JMSClientEntryInfo[] clientsEntryInfo, PrintStream out) {
        for (int i = 0; i < clientsEntryInfo.length; ++i) {
            JMSClientEntryInfo entryInfo = clientsEntryInfo[i];
            TEMP_DATE.setTime(entryInfo.getStartTime());
            out.print("  " + JMSEntryAllCommand.printFixSize((String)entryInfo.getEntryName(), (int)20));
            out.print(JMSEntryAllCommand.printFixSize((String)DATE_FORMAT.format(TEMP_DATE), (int)25));
            if (entryInfo.getHostAddress() == null) {
                out.println("(in VM)");
                continue;
            }
            out.println(entryInfo.getHostAddress() + ":" + entryInfo.getPort());
        }
    }
}

