/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSDestinationResourceMBean;
import jeus.jms.server.mbean.JMSQueueDestinationResourceMBean;
import jeus.jms.server.mbean.JMSTopicDestinationResourceMBean;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;

public class JMSRestatCommand
extends JMSCommand {
    private Argument destNameArg = new Argument("dest_name", "destination name");

    public JMSRestatCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "restat", "Reinitialize destination statistics ", utility, container);
        this.registerArgument(this.destNameArg);
    }

    public void run(PrintStream out) throws Exception {
        String destName = this.destNameArg.getValue();
        ObjectName[] destNames = JMXUtility.queryJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSDestinationResource", (String)"Name", (String)destName);
        if (destNames == null) {
            out.println("No destination : " + destName);
        } else {
            for (int i = 0; i < destNames.length; ++i) {
                JMSDestinationResourceMBean mbean = (JMSDestinationResourceMBean)JMSRestatCommand.newProxyInstance(this.utility, destNames[i], JMSQueueDestinationResourceMBean.class, JMSTopicDestinationResourceMBean.class, false);
                mbean.resetMessageStats();
            }
        }
    }

    private void restat(JMSQueueDestinationResourceMBean mbean) {
        mbean.resetMessageStats();
    }
}

