/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;

public class JMSTakeoverCommand
extends JMSCommand {
    private Argument activeBrokerArg = new Argument("activeBrokerName", "active broker name to be took over");

    public JMSTakeoverCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "takeover", "take over messages of standby broker to active broker.", utility, container);
        this.registerArgument(this.activeBrokerArg);
    }

    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsMbean = this.getJMSResourceMBean();
        long takeovered = jmsMbean.takeover(this.activeBrokerArg.getValue());
        this.directLogWithSpace("Takeover message count : " + takeovered, out);
    }
}

