/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.JMSEndpointStats;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.mbean.JMSProducerResource;
import jeus.jms.server.message.ServerMessage;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public abstract class AbstractProducer
implements MessageHandler {
    private SynchronizedBoolean started;
    protected String producerName;
    protected String destinationName;
    protected final long connectionID;
    protected final int producerID;
    protected JMSProducerResource resource;
    protected JMSEndpointStats stats;
    protected CountStatisticImpl messageCount;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public AbstractProducer(String destinationName, long connectionID, int producerID) {
        this.destinationName = destinationName;
        this.connectionID = connectionID;
        this.producerID = producerID;
        this.started = new SynchronizedBoolean(false);
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        if (packet.isAdminMessage()) {
            this.handleAdminMessage((AdminMessage)packet);
        } else {
            this.handleUserMessage((ServerMessage)packet);
        }
    }

    void handleAdminMessage(AdminMessage message) throws JMSException {
        if (message.isPublic()) {
            this.handlePublicAdminMessage(message);
            return;
        }
        switch (message.getOperationID()) {
            case 50: 
            case 51: {
                this.sendReplyMessage(message);
                break;
            }
            case 5: {
                this.stopProducer(message);
                break;
            }
            case 6: {
                this.closeProducer(message);
                break;
            }
            default: {
                throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
            }
        }
    }

    void handlePublicAdminMessage(AdminMessage message) throws JMSException {
        throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
    }

    void acknowledge(MetaHeader metaHeader, MessageID messageID) throws JMSException {
        MessageHandleEvent reply = MessageUtil.createEventMessage((byte)50, metaHeader, messageID);
        reply.setBooleanFlag(messageID.isPersisted());
        this.sendReplyMessage(reply);
    }

    void nacknowledge(MetaHeader metaHeader, MessageID messageID, JMSException ex) throws JMSException {
        MessageHandleEvent reply = MessageUtil.createEventMessage((byte)51, metaHeader, messageID);
        reply.setException(ex);
        this.sendReplyMessage(reply);
    }

    void succeededMessage(ServerMessage message) throws JMSException {
        if (message.isRequestMessage()) {
            MessageHandleEvent reply = MessageUtil.createEventMessage((byte)50, message.getMetaHeader(), message.getMessageID());
            reply.setIntegerFlag(message.getRedeliveryLimit());
            reply.setBooleanFlag(message.isPersisted());
            this.sendReplyMessage(reply);
        }
    }

    void failedMessage(ServerMessage message, JMSException ex) {
        block4: {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5741_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5741_LEVEL, JeusMessage_JMS5._5741, message, (Throwable)ex);
            }
            if (ex instanceof InvalidDestinationException) {
                DestinationManager manager = DestinationUtil.getDeadLetterQueue();
                manager.enqueue(message);
            }
            try {
                this.nacknowledge(message.getMetaHeader(), message.getMessageID(), ex);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5742_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS5._5742_LEVEL, JeusMessage_JMS5._5742, message, (Throwable)e);
            }
        }
    }

    void handleUserMessage(ServerMessage message) throws JMSException {
        if (!message.isLocalMessage()) {
            message.parseJMSHeader();
        }
        this.increateMessageCounter();
        this.checkMessageRouting(message);
        if (message.isServerRouting()) {
            this.serverRouting(message);
        } else if (message.isClientRouting()) {
            this.clientRouting(message);
        } else {
            this.deliverDestination(message);
        }
    }

    void checkMessageRouting(ServerMessage message) throws JMSException {
    }

    void prepareServerRouting(ServerMessage message) throws JMSException {
        String brokerName = message.getDestination().getBrokerName();
        ClusteredPeer peer = ClusterManager.getClusterPeer(brokerName);
        message.setBrokerID(peer.getBrokerID());
    }

    void prepareClientRouting(ServerMessage message) {
        DestinationIdentity destination = message.getDestination();
        message.setEntryID(destination.getEntryID());
        message.setConnectionID(destination.getTemporaryConnectionID());
        message.setTargetID((byte)7);
    }

    abstract void clientRouting(ServerMessage var1) throws JMSException;

    abstract void serverRouting(ServerMessage var1) throws JMSException;

    abstract void sendReplyMessage(AdminMessage var1) throws JMSException;

    abstract void deliverDestination(ServerMessage var1) throws JMSException;

    abstract void stopProducer(AdminMessage var1) throws JMSException;

    abstract void closeProducer(AdminMessage var1) throws JMSException;

    abstract J2EEManagedObject getParentMBeanObject();

    void shutdown() {
        this.destroyMBean();
    }

    void registerMBean() throws JMSException {
        try {
            this.resource = JMSProducerResource.createMBean(this.producerName, this.getParentMBeanObject(), this);
            this.stats = this.resource.getInitialStats();
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.messageCount = (CountStatisticImpl)this.stats.getMessageCount();
        this.started.set(true);
    }

    void destroyMBean() {
        this.resource.destroyMBean();
    }

    void increateMessageCounter() {
        this.messageCount.increase();
    }

    public void refresh() {
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public int getProducerID() {
        return this.producerID;
    }

    public String getDigest() {
        return this.producerName;
    }

    public String toString() {
        return this.producerName;
    }
}

