/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.Stats;
import javax.transaction.xa.XAException;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CallBackAddressMessage;
import jeus.jms.common.message.admin.CheckDestinationMessage;
import jeus.jms.common.message.admin.CreateConnectionMessage;
import jeus.jms.common.message.admin.CreateDestinationMessage;
import jeus.jms.common.message.admin.GlobalTransactionMessage;
import jeus.jms.common.message.admin.GlobalTransactionRecoverMessage;
import jeus.jms.common.message.admin.GlobalTransactionReplyMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSXid;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.JMSConnection;
import jeus.jms.server.JMSSession;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.manager.AdministeredObjectBinder;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.ConnectionManager;
import jeus.jms.server.manager.DestinationFactory;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.mbean.JMSClientResource;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.transaction.SharedTransactionContext;
import jeus.jms.server.transaction.TransactionManager;
import jeus.jms.server.util.LoginManager;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.security.util.LoginUtil;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public abstract class JMSClientEntry
extends JMSBaseEntry {
    protected JMSServiceChannel channel;
    private BoundedInteger sequencer;
    private SerialExecutionQueue recvQueue;
    private Object subject;
    protected Map connections;
    protected SynchronizedBoolean closed;
    private JMSClientResource clientResource;
    private CountStatisticImpl connsCount;
    private SharedTransactionContext sharedTxContext;
    private SerialExecutor cachedExecutor = JMSBroker.getLocalBroker().getCachedSerialExecutor();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSClientEntry(JMSServiceChannel channel) {
        super(JMSBroker.getLocalBroker().getRequestManager(), JMSBroker.getLocalBroker().getSerialExecutor());
        this.brokerID = ClusterManager.LOCAL_BROKER_ID;
        this.brokerName = ClusterManager.LOCAL_BROKER_NAME;
        this.channel = channel;
        this.connections = Collections.synchronizedMap(new HashMap());
    }

    public void init() throws JMSException {
        this.id = StorageManager.getNextEntryID();
        this.name = this.createName();
        this.sequencer = BoundedInteger.getIncrementor();
        this.closed = new SynchronizedBoolean(false);
        this.recvQueue = new SerialExecution();
        this.registerMBean();
    }

    private void registerMBean() throws JMSException {
        try {
            this.clientResource = JMSClientResource.createMBean(this.name, this.channel.getMBean(), this);
            this.connsCount = (CountStatisticImpl)this.clientResource.getConnectionCount();
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
    }

    private void unregisterMBean() {
        if (this.clientResource == null) {
            return;
        }
        this.clientResource.destroyMBean();
        this.clientResource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminMessage shutdownByClient(AdminMessage message) throws JMSException {
        Collection collection = this.connections.values();
        JMSConnection[] connections = collection.toArray(new JMSConnection[collection.size()]);
        for (int i = 0; i < connections.length; ++i) {
            JMSConnection connection = connections[i];
            try {
                connection.shutdownAll();
                continue;
            }
            catch (Throwable t) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5681_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._5681_LEVEL, JeusMessage_JMS5._5681, connection, t);
            }
        }
        this.prepareShutdown();
        try {
            this.sendReplyDirect(message);
        }
        finally {
            this.shutdown();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAll() {
        try {
            Collection collection = this.connections.values();
            JMSConnection[] connections = collection.toArray(new JMSConnection[collection.size()]);
            for (int i = 0; i < connections.length; ++i) {
                JMSConnection connection = connections[i];
                try {
                    connection.shutdownAll();
                    continue;
                }
                catch (Throwable t) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5682_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS5._5682_LEVEL, JeusMessage_JMS5._5682, connection, t);
                }
            }
        }
        finally {
            this.shutdown();
        }
    }

    public boolean isNeedRouting(MessageContainer packet) {
        boolean needRouting = packet.getBrokerID() != this.broker.getBrokerID();
        packet.setServerRouting(needRouting);
        return packet.isRouting();
    }

    public JMSBaseEntry getRoutingEntry(MessageContainer data) throws JMSException {
        if (data.isServerRouting()) {
            return this.channel.getClusterEntry(data.getBrokerID());
        }
        return this.channel.getClientEntry(data.getEntryID());
    }

    public void recvData(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5683_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5683_LEVEL, JeusMessage_JMS5._5683, new Object[]{packet, this});
        }
        this.handleArrivedMessage(packet);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void handleMissingMessage(MessageContainer packet, JMSException ex) {
    }

    public void handleRequestMessage(MessageContainer message) {
        try {
            SerialExecutionQueue container = this.findExecution(message);
            if (message.isXAExecutable()) {
                this.cachedExecutor.execute(container, message);
            } else {
                this.executor.execute(container, message);
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.sendFailedReply(message, e);
        }
    }

    private SerialExecutionQueue findExecution(MessageContainer message) throws JMSException {
        byte targetID = message.getLocalTargetID();
        switch (targetID) {
            case 3: 
            case 6: {
                return this.recvQueue;
            }
            case 7: 
            case 14: 
            case 22: 
            case 23: {
                return this.getJMSConnection(message.getConnectionID()).getExecutionContainer();
            }
            case 15: 
            case 30: 
            case 31: 
            case 46: 
            case 47: {
                JMSConnection connection = this.getJMSConnection(message.getConnectionID());
                JMSSession session = connection.getSession(message.getSessionID());
                return session.getExecutionContainer();
            }
        }
        throw new JMSException("invalid target ID " + targetID);
    }

    private JMSConnection getJMSConnection(int connectionID) throws JMSException {
        JMSConnection connection = (JMSConnection)this.connections.get(new Integer(connectionID));
        if (connection == null) {
            throw new JMSException("invalid connection ID " + connectionID);
        }
        return connection;
    }

    private AdminMessage forgetGlobalTransaction(GlobalTransactionMessage forget) {
        JMSXid xid = forget.getXid();
        try {
            TransactionManager.getInstance().forget(xid);
            return this.createTxSuccessMessage(forget.getMetaHeader());
        }
        catch (XAException t) {
            return this.createTxFailMessage(forget.getMetaHeader(), t);
        }
    }

    private AdminMessage prepareGlobalTransaction(GlobalTransactionMessage prepare) {
        JMSXid xid = prepare.getXid();
        long timeout = prepare.getTimeout();
        try {
            int result = TransactionManager.getInstance().prepare(xid, timeout, prepare.isRemote());
            return this.createTxReplyMessage(prepare.getMetaHeader(), result);
        }
        catch (XAException xae) {
            return this.createTxFailMessage(prepare.getMetaHeader(), xae);
        }
    }

    private AdminMessage commitGlobalTransaction(GlobalTransactionMessage commit) {
        JMSXid xid = commit.getXid();
        boolean onePhase = commit.getBooleanFlag();
        long timeout = commit.getTimeout();
        try {
            TransactionManager.getInstance().commit(xid, onePhase, timeout, commit.isRemote());
            return this.createTxSuccessMessage(commit.getMetaHeader());
        }
        catch (XAException xae) {
            return this.createTxFailMessage(commit.getMetaHeader(), xae);
        }
    }

    private AdminMessage rollbackGlobalTransaction(GlobalTransactionMessage rollback) {
        JMSXid xid = rollback.getXid();
        try {
            TransactionManager.getInstance().rollback(xid, rollback.isRemote());
            return this.createTxSuccessMessage(rollback.getMetaHeader());
        }
        catch (XAException xae) {
            return this.createTxFailMessage(rollback.getMetaHeader(), xae);
        }
    }

    private AdminMessage recoverGloabalTransaction(GlobalTransactionRecoverMessage recover) {
        try {
            int flag = recover.getIntegerFlag();
            recover.setXidList(TransactionManager.getInstance().recover(flag));
        }
        catch (Exception e) {
            JMSException ex = JMSExceptionFactory.createJMSException("Exception occurred", e);
            recover.setException(ex);
        }
        return recover;
    }

    private AdminMessage sharedTransactionContext(AdminMessage shared) {
        this.sharedTxContext = this.sharedTxContext == null ? new SharedTransactionContext() : this.sharedTxContext;
        return MessageUtil.createAdminMessage(shared.getMetaHeader());
    }

    private void checkSharedContext() throws IllegalStateException {
        if (this.sharedTxContext == null) {
            throw new IllegalStateException("not in shared context");
        }
    }

    private AdminMessage beginLocalTransaction(AdminMessage begin) throws JMSException {
        this.checkSharedContext();
        this.sharedTxContext.beginLocalTransaction();
        return MessageUtil.createAdminMessage(begin.getMetaHeader());
    }

    private AdminMessage commitLocalTransaction(AdminMessage commit) throws JMSException {
        this.checkSharedContext();
        this.sharedTxContext.commitLocalTransaction();
        return MessageUtil.createAdminMessage(commit.getMetaHeader());
    }

    private AdminMessage rollbackLocalTransaction(AdminMessage rollback) throws JMSException {
        this.checkSharedContext();
        this.sharedTxContext.rollbackLocalTransaction();
        return MessageUtil.createAdminMessage(rollback.getMetaHeader());
    }

    private AdminMessage startGlobalTransaction(GlobalTransactionMessage start) throws JMSException {
        this.checkSharedContext();
        JMSXid xid = start.getXid();
        int flag = start.getIntegerFlag();
        long timeout = start.getTimeout();
        try {
            this.sharedTxContext.startGlobalTransaction(xid, flag, timeout, start.isRemote());
        }
        catch (XAException xae) {
            return this.createTxFailMessage(start.getMetaHeader(), xae);
        }
        return this.createTxSuccessMessage(start.getMetaHeader());
    }

    private AdminMessage endGlobalTransaction(GlobalTransactionMessage end) throws JMSException {
        this.checkSharedContext();
        int flag = end.getIntegerFlag();
        JMSXid xid = end.getXid();
        long timeout = end.getTimeout();
        try {
            this.sharedTxContext.endGlobalTransaction(xid, flag, timeout);
        }
        catch (XAException xae) {
            return this.createTxFailMessage(end.getMetaHeader(), xae);
        }
        return this.createTxSuccessMessage(end.getMetaHeader());
    }

    private AdminMessage createConnection(CreateConnectionMessage create) throws JMSException {
        String clientID = create.getClientID();
        if (clientID != null && !create.isFixedClientID()) {
            clientID = clientID + "." + this.id;
        }
        Object subject = LoginManager.createSubject(create.getUserName(), create.getPassword());
        this.authorize(subject, JMSResource.CONNECT_PERMISSION);
        this.subject = subject;
        ConnectionManager.registerClientID(clientID, this);
        int connectionID = this.sequencer.getNextValue();
        JMSConnection connection = new JMSConnection(this, this.clientResource, clientID, connectionID);
        this.registerConnection(connectionID, connection);
        create.setTargetID((byte)7);
        create.setAllocatedConnectionID(connectionID);
        return MessageUtil.createAdminMessage(create.getMetaHeader());
    }

    private AdminMessage checkDestination(CheckDestinationMessage message) throws JMSException {
        short brokerID;
        String destName = message.getDestinationName();
        int index = destName.indexOf(58);
        if (index < 0) {
            brokerID = ClusterManager.LOCAL_BROKER_ID;
            try {
                DestinationUtil.getLocalDestinationManager(destName);
                message.setExists(true);
            }
            catch (InvalidDestinationException e) {
                message.setExists(false);
            }
        } else {
            ClusteredPeer peer = ClusterManager.getClusterPeer(destName.substring(0, index));
            brokerID = peer.getBrokerID();
        }
        message.setBrokerID(brokerID);
        return message;
    }

    private AdminMessage createDestination(CreateDestinationMessage command) throws JMSException {
        String brokerName = command.getBrokerName();
        if (brokerName != null && !brokerName.equals(ClusterManager.LOCAL_BROKER_NAME)) {
            throw new InvalidDestinationException("not supported action");
        }
        this.authorize(this.subject, JMSResource.CREATE_PERMISSION);
        try {
            String exportName;
            LoginUtil.loginCodeSubjectWithRuntimeException();
            String string = exportName = command.getExportName() == null ? command.getDestName() : command.getExportName();
            if (AdministeredObjectBinder.isAlreadyBound(exportName)) {
                throw new InvalidDestinationException("export name " + exportName + " is already bound");
            }
            this.createLocalDestination(command);
            AdminMessage adminMessage = MessageUtil.createAdminMessage(command.getMetaHeader());
            return adminMessage;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5684_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5684_LEVEL, JeusMessage_JMS5._5684, e);
            }
            throw JMSExceptionFactory.createJMSException("failed to create destination by exception", e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private void createLocalDestination(CreateDestinationMessage command) throws JMSException {
        String destName = command.getDestName();
        byte type = command.isQueue() ? (byte)81 : 84;
        JeusDestination destination = DestinationFactory.createDestination(type, destName, command.getExportName(), command.getMultipleReceiver(), null);
        DestinationUtil.createDestinationManager(destination);
    }

    private AdminMessage createTxFailMessage(MetaHeader header, XAException xae) {
        JMSException ex = JMSExceptionFactory.createJMSException("Exception occurred.", (Exception)xae);
        AdminMessage reply = this.createTxReplyMessage(header, (byte)-1);
        reply.setException(ex);
        return reply;
    }

    private AdminMessage createTxSuccessMessage(MetaHeader header) {
        return this.createTxReplyMessage(header, (byte)0);
    }

    private AdminMessage createTxReplyMessage(MetaHeader header, byte flag) {
        GlobalTransactionReplyMessage reply = MessageUtil.createXAReplyMessage(header);
        reply.setByteFlag(flag);
        return reply;
    }

    private AdminMessage createTxReplyMessage(MetaHeader header, int flag) {
        GlobalTransactionReplyMessage reply = MessageUtil.createXAReplyMessage(header);
        reply.setIntegerFlag(flag);
        return reply;
    }

    private void authorize(Object subject, Permission permission) throws JMSException {
        if (this.channel.isCheckSecurity()) {
            LoginManager.authorize(subject, permission);
        }
    }

    public SharedTransactionContext getSharedContext() {
        return this.sharedTxContext;
    }

    public void clearResource() {
        this.unregisterMBean();
    }

    public void unregisterClientChannel() {
    }

    public void registerConnection(int connectionID, JMSConnection connection) {
        this.connections.put(new Integer(connectionID), connection);
        this.connsCount.increase();
    }

    public void unregisterConnection(int connectionID) {
        this.connections.remove(new Integer(connectionID));
        this.connsCount.decrease();
    }

    public void registerConnectionStats(Stats stats) {
        this.channel.getMBean().addJMSConnectionStats(stats);
    }

    public void unregisterConnectionStats(Stats stats) {
        this.channel.getMBean().removeJMSConnectionStats(stats);
    }

    private AdminMessage registerListeningAddress(CallBackAddressMessage message) {
        message.getIpAddress();
        return message;
    }

    public abstract String createName();

    public abstract String getHostName();

    public abstract int getPort();

    public String getDigest() {
        return this.name + "[" + this.getHostName() + ":" + this.getPort() + "] " + this.connections.size() + " connection";
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    private class SerialExecution
    extends SerialExecutable
    implements MessageHandler {
        private SerialExecution() {
        }

        public void execute(MessageContainer packet) throws JMSException {
            this.handleMessage(packet);
        }

        public void exception(MessageContainer packet, JMSException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5685_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5685_LEVEL, JeusMessage_JMS5._5685, e);
            }
            JMSClientEntry.this.sendFailedReply(packet, e);
        }

        public void failed(MessageContainer packet, Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5686_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5686_LEVEL, JeusMessage_JMS5._5686, t);
            }
            JMSException ex = new JMSException("internal error for " + (t != null ? t.toString() : "null"));
            JMSClientEntry.this.sendFailedReply(packet, ex);
        }

        public void handleMessage(MessageContainer packet) throws JMSException {
            AdminMessage result = this.handleAdminMessage((AdminMessage)packet);
            if (!JMSClientEntry.this.closed.get() && result != null && packet.isRequestMessage()) {
                JMSClientEntry.this.sendReplyMessage(result);
            }
        }

        private AdminMessage handleAdminMessage(AdminMessage message) throws JMSException {
            switch (message.getOperationID()) {
                case 6: {
                    return JMSClientEntry.this.shutdownByClient(message);
                }
                case 8: {
                    return JMSClientEntry.this.createConnection((CreateConnectionMessage)message);
                }
                case 21: {
                    return JMSClientEntry.this.checkDestination((CheckDestinationMessage)message);
                }
                case 20: {
                    return JMSClientEntry.this.registerListeningAddress((CallBackAddressMessage)message);
                }
                case 98: {
                    return JMSClientEntry.this.prepareGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 99: {
                    return JMSClientEntry.this.commitGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 100: {
                    return JMSClientEntry.this.rollbackGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 102: {
                    return JMSClientEntry.this.recoverGloabalTransaction((GlobalTransactionRecoverMessage)message);
                }
                case 101: {
                    return JMSClientEntry.this.forgetGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 111: {
                    return JMSClientEntry.this.sharedTransactionContext(message);
                }
                case 96: {
                    return JMSClientEntry.this.startGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 97: {
                    return JMSClientEntry.this.endGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 80: {
                    return JMSClientEntry.this.beginLocalTransaction(message);
                }
                case 81: {
                    return JMSClientEntry.this.commitLocalTransaction(message);
                }
                case 82: {
                    return JMSClientEntry.this.rollbackLocalTransaction(message);
                }
                case 17: {
                    return JMSClientEntry.this.createDestination((CreateDestinationMessage)message);
                }
                case 2: {
                    return message;
                }
            }
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
        }

        public void handleException(MessageContainer packet, JMSException e) {
            JMSClientEntry.this.sendFailedReply(packet, e);
        }

        public boolean delegate() {
            return false;
        }

        public String toString() {
            return JMSClientEntry.this.name + ".RCV.QUEUE[" + this.size() + "]";
        }
    }
}

