/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.comm.IntermediateMessageAssembler;
import jeus.jms.common.comm.MessageFabricator;
import jeus.jms.common.comm.MessageWriter;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CheckDestinationMessage;
import jeus.jms.common.message.admin.RegisterCallbackMessage;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.JMSClusterProducer;
import jeus.jms.server.JMSServer;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.comm.ServerMessageFabricator;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.mbean.JMSClusterResource;
import jeus.net.AcceptorConnectionListener;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSClusterEntry
extends JMSBaseEntry
implements JMSRemoteEntry,
AcceptorConnectionListener {
    private JMSClusterResource resource;
    protected JMSServiceChannel channel;
    protected SocketStream stream;
    protected MessageWriter writer;
    protected ClusteredPeer peer;
    private Map messageConsumers;
    private JMSClusterProducer producer;
    private SerialExecutor serialExecutor;
    private SerialExecutionQueue recvQueue;
    protected SynchronizedBoolean closed;
    private Map assemblers;
    private MessageFabricator fabricator;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSClusterEntry(JMSServiceChannel channel, ClusteredPeer peer) {
        super(JMSBroker.getLocalBroker().getRequestManager(), JMSBroker.getLocalBroker().getSerialExecutor());
        this.channel = channel;
        this.peer = peer;
        this.closed = new SynchronizedBoolean(false);
        this.assemblers = new HashMap();
        this.brokerID = peer.getBrokerID();
        this.brokerName = peer.getBrokerName();
        this.fabricator = new ServerMessageFabricator(this);
    }

    public JMSClusterEntry(JMSServiceChannel channel, ClusteredPeer peer, SocketStream stream) throws Exception {
        this(channel, peer);
        this.init(stream);
    }

    public void init(SocketStream sockStream) {
        block3: {
            this.id = StorageManager.getNextEntryID();
            this.name = "JMSCluster[" + ClusterManager.LOCAL_BROKER_NAME + "->" + this.peer.getBrokerName() + "]";
            this.serialExecutor = new SerialExecutor((Executor)ThreadPoolManager.getThreadPool());
            this.recvQueue = new SerialExecution();
            this.messageConsumers = new Hashtable();
            this.stream = sockStream;
            try {
                this.stream.getSocket().setSoTimeout(this.channel.getConnectionTimeout() * 60 * 1000);
            }
            catch (SocketException e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5081_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5081_LEVEL, JeusMessage_JMS5._5081, e.getMessage());
                }
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5082_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._5082_LEVEL, JeusMessage_JMS5._5082, e);
            }
        }
    }

    public IntermediateMessageAssembler getMessageAssembler(int partialID) {
        return (IntermediateMessageAssembler)this.assemblers.get(new Integer(partialID));
    }

    public void addMessageAssembler(int partialID, IntermediateMessageAssembler assembler) {
        this.assemblers.put(new Integer(partialID), assembler);
    }

    public void removeMessageAssembler(int partialID) {
        this.assemblers.remove(new Integer(partialID));
    }

    public SocketStream getSocketStream() {
        return this.stream;
    }

    public boolean isSocketStreamUpdatable() {
        return false;
    }

    public void setSocketStream(SocketStream stream) throws IOException {
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
        this.init(sockStream);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5083_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5083_LEVEL, JeusMessage_JMS5._5083, this);
        }
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
        AdminMessage reply = (AdminMessage)piggybackedData;
        if (reply.getOperationID() != 16) {
            throw reply.getException();
        }
        this.start();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5084_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5084_LEVEL, JeusMessage_JMS5._5084, this);
        }
    }

    public void connectionEstablished(SocketStream stream) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5085_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5085_LEVEL, JeusMessage_JMS5._5085, this);
        }
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        this.start();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5086_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5086_LEVEL, JeusMessage_JMS5._5086, this);
        }
    }

    public void connectionClosed(Exception exception) {
        this.connectionClosed(exception, this.stream);
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (exception == null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5087_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5087_LEVEL, JeusMessage_JMS5._5087, this);
            }
        } else if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5088_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5088_LEVEL, JeusMessage_JMS5._5088, this, (Throwable)exception);
        }
        if (this.writer != null) {
            this.writer.connectionClosed();
        }
        this.channel.failedClusterChannel(this);
        this.peer.connectionClosed();
    }

    public void runDelegatedTask(Runnable processor, boolean isReplyPacket, Object message) {
        this.channel.runMessageProcessor(processor);
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) throws Exception {
        byte[] data = (byte[])obj;
        MessageContainer message = this.fabricator.fabricate(data);
        this.recvData(message);
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return MessageUtil.createServerEstablishMessage(ClusterManager.LOCAL_BROKER_NAME);
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void start() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5089_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5089_LEVEL, JeusMessage_JMS5._5089, this);
        }
        this.channel.registerClusterEntry(this.peer.getBrokerID(), this);
        this.writer = this.channel.createMessageWriter(this, this.stream);
        this.writer.startExecution();
        try {
            this.registerMBean();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        this.peer.established(this);
    }

    public void prepareShutdown() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5090_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5090_LEVEL, JeusMessage_JMS5._5090, this);
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.prepareShutdown();
        }
        this.unregisterClusterChannel();
    }

    public void unregisterClusterChannel() {
        this.channel.unregisterClusterEntry(this.peer.getBrokerID(), this);
        this.peer.shutdown();
    }

    public void shutdown() {
        this.prepareShutdown();
        if (this.writer != null) {
            this.writer.shutdown();
        }
        this.unregisterMBean();
    }

    public void shutdownAll() {
        this.shutdown();
    }

    public String getAddress() {
        return this.peer.getHostName() + ":" + this.peer.getPort();
    }

    private void registerMBean() throws JMSException {
        try {
            this.resource = JMSClusterResource.createMBean(this.name, this.channel.getObjectName(), this);
            this.producer = new JMSClusterProducer(null, this, this.id);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for cluster entry by " + e);
        }
    }

    private void unregisterMBean() {
        if (this.resource != null) {
            this.resource.destroyMBean();
            this.resource = null;
        }
        if (this.producer != null) {
            this.producer.shutdown();
            this.producer = null;
        }
    }

    public JMSClusterResource getMBeanObject() {
        return this.resource;
    }

    public boolean isNeedRouting(MessageContainer packet) {
        if (JMSServer.isSAFEngine()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5091_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5091_LEVEL, JeusMessage_JMS5._5091);
            }
            return false;
        }
        boolean needRouting = packet.getBrokerID() != this.broker.getBrokerID();
        packet.setServerRouting(needRouting);
        return packet.isRouting();
    }

    public boolean isRemote() {
        return true;
    }

    public void sendData(MessageContainer message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5092_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5092_LEVEL, JeusMessage_JMS5._5092, new Object[]{message, this});
        }
        message.setBrokerID(this.peer.getBrokerID());
        try {
            this.writer.enqueue(this.serialExecutor, message);
        }
        catch (Exception e) {
            throw JMSExceptionFactory.createJMSException("failed to send " + message + " for " + e.getMessage(), e);
        }
    }

    public void recvData(MessageContainer message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5093_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5093_LEVEL, JeusMessage_JMS5._5093, new Object[]{message, this});
        }
        this.handleArrivedMessage(message);
    }

    public void sendDirect(MessageContainer packet) throws JMSException {
        try {
            this.writer.executeDirect(packet);
        }
        catch (Exception e) {
            throw new JMSException("failed to send for " + e.toString());
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void handleRequestMessage(MessageContainer packet) {
        this.serialExecutor.execute(this.recvQueue, packet);
    }

    public void handleRouting(MessageHandler handler, MessageContainer packet) {
        try {
            JMSBaseEntry target = this.getRoutingEntry(packet);
            target.sendRoutingRequest(handler, packet);
        }
        catch (JMSException ex) {
            handler.handleException(packet, ex);
        }
    }

    public JMSBaseEntry getRoutingEntry(MessageContainer data) throws JMSException {
        if (data.isServerRouting()) {
            return this.channel.getClusterEntry(data.getBrokerID());
        }
        return this.channel.getClientEntry(data.getEntryID());
    }

    public void handleMissingMessage(MessageContainer packet, JMSException ex) {
        block3: {
            if (packet.isRequestMessage()) {
                AdminMessage result = MessageUtil.createAdminMessage(packet.getMetaHeader());
                result.setException(ex);
                try {
                    this.sendReplyMessage(result);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5094_LEVEL)) break block3;
                    LogUtils.log(logger, JeusMessage_JMS5._5094_LEVEL, JeusMessage_JMS5._5094, new Object[]{packet, e.getMessage()});
                }
            }
        }
    }

    private void handleRequest(MessageContainer packet) throws JMSException {
        packet.setBrokerID(ClusterManager.LOCAL_BROKER_ID);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5095_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5095_LEVEL, JeusMessage_JMS5._5095, packet);
        }
        if (packet.isAdminMessage()) {
            this.handleAdminMessage((AdminMessage)packet);
        } else {
            this.producer.handleMessage(packet);
        }
    }

    private void handleAdminMessage(AdminMessage message) throws JMSException {
        switch (message.getOperationID()) {
            case 21: {
                this.checkDestination((CheckDestinationMessage)message);
                break;
            }
            case 112: {
                this.handleConsumerCallback((RegisterCallbackMessage)message);
                break;
            }
            default: {
                this.handleFacilityAdminMessage(message);
            }
        }
    }

    private void handleFacilityAdminMessage(AdminMessage message) throws JMSException {
        switch (message.getLocalTargetID()) {
            case 3: {
                break;
            }
            case 7: {
                break;
            }
            case 31: {
                AbstractConsumer consumer = this.getConsumer(message.getConsumerID());
                consumer.handleMessage(message);
                break;
            }
        }
    }

    private void checkDestination(CheckDestinationMessage message) throws JMSException {
        String destName = message.getDestinationName();
        try {
            DestinationUtil.getLocalDestinationManager(destName);
            message.setExists(true);
        }
        catch (InvalidDestinationException e) {
            message.setExists(false);
        }
        this.sendData(message);
    }

    private void handleConsumerCallback(RegisterCallbackMessage callback) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5096_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5096_LEVEL, JeusMessage_JMS5._5096, callback);
        }
        String destName = callback.getDestinationName();
        DestinationManager manager = DestinationUtil.getLocalDestinationManager(destName);
        manager.registerCallback(callback.getConsumerID(), this);
    }

    public void registerConsumer(int consumerID, AbstractConsumer consumer) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5097_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5097_LEVEL, JeusMessage_JMS5._5097, new Object[]{consumer, new Integer(consumerID)});
        }
        this.messageConsumers.put(new Integer(consumerID), consumer);
        this.registerConsumerCallback(consumer);
    }

    private void registerConsumerCallback(AbstractConsumer consumer) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5098_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5098_LEVEL, JeusMessage_JMS5._5098, consumer);
        }
        String destName = consumer.getSubscriptionManager().getDestinationName();
        RegisterCallbackMessage register = new RegisterCallbackMessage(destName);
        register.setTargetID((byte)31);
        register.setBrokerID(this.peer.getBrokerID());
        register.setConsumerID(consumer.getConsumerID());
        this.sendRequestMessage(register);
    }

    public AbstractConsumer getConsumer(int consumerID) throws JMSException {
        AbstractConsumer consumer = this.findConsumer(consumerID);
        if (consumer == null) {
            throw new JMSException("invalid consumer id " + consumerID);
        }
        return consumer;
    }

    public AbstractConsumer findConsumer(int consumerID) {
        return (AbstractConsumer)this.messageConsumers.get(new Integer(consumerID));
    }

    public void consumerClosed(int consumerID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5099_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5099_LEVEL, JeusMessage_JMS5._5099, new Integer(consumerID));
        }
        this.messageConsumers.remove(new Integer(consumerID));
    }

    public ClusteredPeer getClusteredPeer() {
        return this.peer;
    }

    public boolean useDirectByteBuffer() {
        return this.channel.useDirectByteBuffer();
    }

    public String toString() {
        return this.name;
    }

    private class SerialExecution
    extends SerialExecutable {
        private SerialExecution() {
        }

        public void execute(MessageContainer packet) throws JMSException {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5100_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5100_LEVEL, JeusMessage_JMS5._5100, new Object[]{packet, JMSClusterEntry.this});
            }
            JMSClusterEntry.this.handleRequest(packet);
        }

        public void exception(MessageContainer packet, JMSException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5101_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5101_LEVEL, JeusMessage_JMS5._5101, (Object)new Object[]{packet, JMSClusterEntry.this}, (Throwable)e);
            }
            JMSClusterEntry.this.handleMissingMessage(packet, e);
        }

        public String toString() {
            return JMSClusterEntry.this.name + ".RCV.QUEUE[" + this.size() + "]";
        }
    }
}

