/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.server.AbstractProducer;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSClusterProducer
extends AbstractProducer {
    protected JMSClusterEntry entry;

    public JMSClusterProducer(String destName, JMSClusterEntry entry, long connectionID) throws JMSException {
        super(destName, connectionID, -1);
        this.entry = entry;
        this.producerName = entry.getName() + ".P" + connectionID;
        this.registerMBean();
    }

    public void handleMessage(MessageContainer packet) {
        try {
            super.handleMessage(packet);
        }
        catch (JMSException e) {
            this.handleException(packet, e);
        }
    }

    public void handleException(MessageContainer packet, JMSException exception) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6791_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6791_LEVEL, JeusMessage_JMS5._6791, packet, (Throwable)exception);
        }
        if (packet.isAdminMessage()) {
            AdminMessage reply = MessageUtil.createAdminMessage(packet.getMetaHeader());
            reply.setException(exception);
            try {
                this.sendReplyMessage(reply);
            }
            catch (JMSException e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6792_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6792_LEVEL, JeusMessage_JMS5._6792, reply, (Throwable)e);
                }
            }
        } else {
            this.failedMessage((ServerMessage)packet, exception);
        }
    }

    void deliverDestination(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6793_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6793_LEVEL, JeusMessage_JMS5._6793, message);
        }
        message.setLocalConsume(true);
        DestinationIdentity destination = message.getDestination();
        DestinationManager manager = DestinationUtil.getDestinationManager(destination);
        manager.produce(message);
        this.succeededMessage(message);
    }

    void clientRouting(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6794_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6794_LEVEL, JeusMessage_JMS5._6794, message);
        }
        this.prepareClientRouting(message);
        this.entry.handleRoutingRequest(this, message);
    }

    void serverRouting(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6795_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6795_LEVEL, JeusMessage_JMS5._6795, message);
        }
        this.prepareServerRouting(message);
        this.entry.handleRoutingRequest(this, message);
    }

    void sendReplyMessage(AdminMessage reply) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6796_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6796_LEVEL, JeusMessage_JMS5._6796, reply);
        }
        reply.setTargetID((byte)3);
        this.entry.sendReplyMessage(reply);
    }

    void stopProducer(AdminMessage message) throws JMSException {
    }

    void closeProducer(AdminMessage message) throws JMSException {
        this.shutdown();
    }

    J2EEManagedObject getParentMBeanObject() {
        return this.entry.getMBeanObject();
    }
}

