/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CleanUpDurableSubscriberMessage;
import jeus.jms.common.message.admin.CleanUpQueueMessage;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.CreateSessionMessage;
import jeus.jms.common.message.admin.GetDurableMessageLifecycleMessage;
import jeus.jms.common.message.admin.GetMessageLifecycleMessage;
import jeus.jms.common.message.admin.SetClientIDMessage;
import jeus.jms.common.message.admin.UnsubscribeMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.JMSConnectionConsumer;
import jeus.jms.server.JMSSession;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.manager.ConnectionManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.mbean.JMSClientResource;
import jeus.jms.server.mbean.JMSConnectionResource;
import jeus.jms.server.transaction.SharedTransactionContext;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public class JMSConnection
implements SubscriptionContext {
    private final int connectionID;
    private final String connectionName;
    private String clientID;
    private JMSClientEntry entry;
    private SynchronizedBoolean started;
    private SynchronizedBoolean closed;
    private BoundedInteger sequence;
    private Map sessions;
    private Map consumers;
    private SharedTransactionContext context;
    private SerialExecution execution;
    private JMSConnectionResource resource;
    private CountStatisticImpl connectionConsumerCount;
    private CountStatisticImpl sessionCount;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSConnection(JMSClientEntry entry, JMSClientResource clientResource, String clientID, int connectionID) throws JMSException {
        this.entry = entry;
        this.clientID = clientID;
        this.connectionID = connectionID;
        this.connectionName = entry + ".C" + connectionID;
        this.context = entry.getSharedContext();
        this.registerMBean(clientResource);
        this.initialize();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5711_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5711_LEVEL, JeusMessage_JMS5._5711, this);
        }
    }

    private void initialize() {
        this.execution = new SerialExecution();
        this.sessions = Collections.synchronizedMap(new HashMap());
        this.consumers = Collections.synchronizedMap(new HashMap());
        this.sequence = BoundedInteger.getIncrementor();
        this.started = new SynchronizedBoolean(false);
        this.closed = new SynchronizedBoolean(false);
    }

    private void registerMBean(JMSClientResource clientResource) throws JMSException {
        try {
            this.resource = JMSConnectionResource.createMBean(this.connectionName, clientResource, this);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.connectionConsumerCount = (CountStatisticImpl)this.resource.getConnectionConsumerCount();
        this.sessionCount = (CountStatisticImpl)this.resource.getSessionCount();
        this.entry.registerConnectionStats(this.resource.getstats());
    }

    public SharedTransactionContext getSharedContext() {
        return this.context;
    }

    public SerialExecutionQueue getExecutionContainer() {
        return this.execution;
    }

    public void sendMessage(MessageContainer message) throws JMSException {
        message.setConnectionID(this.connectionID);
        this.forward(message);
    }

    public void sendAsyncRequest(MessageHandler handler, MessageContainer message) throws JMSException {
        message.setConnectionID(this.connectionID);
        this.entry.sendAsyncRequest(handler, message);
    }

    public void sendRoutingRequest(MessageHandler handler, MessageContainer message) {
        this.entry.handleRoutingRequest(handler, message);
    }

    private void sendReply(MessageContainer message) throws JMSException {
        message.setRequestFlag(false);
        this.sendMessage(message);
    }

    public void sendFailedReply(MessageContainer message, JMSException e) throws JMSException {
        message.setConnectionID(this.connectionID);
        this.entry.sendFailedReply(message, e);
    }

    private void forward(MessageContainer message) throws JMSException {
        this.entry.sendData(message);
    }

    private void addSession(int id, JMSSession session) {
        this.sessions.put(new Integer(id), session);
        this.sessionCount.increase();
    }

    public JMSSession findSession(int sessionID) {
        return (JMSSession)this.sessions.get(new Integer(sessionID));
    }

    public JMSSession getSession(int sessionID) throws JMSException {
        JMSSession session = this.findSession(sessionID);
        if (session == null) {
            throw new JMSException("invalid session id " + sessionID);
        }
        return session;
    }

    public void sessionRemoved(int sessionID) {
        if (this.sessions.remove(new Integer(sessionID)) != null) {
            this.sessionCount.decrease();
        }
    }

    private void addConnectionConsumer(int id, JMSConnectionConsumer consumer) {
        this.consumers.put(new Integer(id), consumer);
    }

    public JMSConnectionConsumer getConsumer(int consumerID) throws JMSException {
        JMSConnectionConsumer consumer = (JMSConnectionConsumer)this.consumers.get(new Integer(consumerID));
        if (consumer == null) {
            throw new JMSException("invalid consumer id " + consumerID);
        }
        return consumer;
    }

    public void consumerRemoved(int consumerID) {
        if (this.consumers.remove(new Integer(consumerID)) != null) {
            this.connectionConsumerCount.decrease();
        }
    }

    public void close() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5712_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5712_LEVEL, JeusMessage_JMS5._5712, this);
        }
        if (!this.closed.commit(false, true)) {
            return;
        }
        this.clearResource();
        this.entry.unregisterConnection(this.connectionID);
    }

    private void clearResource() {
        this.sessions.clear();
        this.consumers.clear();
        this.unregisterClientID();
        this.destroyMBean();
    }

    private void unregisterClientID() {
        if (this.clientID != null) {
            ConnectionManager.unregisterClientID(this.clientID);
        }
    }

    private void destroyMBean() {
        this.resource.destroyMBean();
        this.entry.unregisterConnectionStats(this.resource.getstats());
    }

    public boolean transactionInProgress() {
        return false;
    }

    public boolean isTransacted() {
        JMSSession[] values = this.sessions.values().toArray(new JMSSession[0]);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].isTransacted()) continue;
            return true;
        }
        return false;
    }

    public JMSConnectionResource getMbeanObject() {
        return this.resource;
    }

    public void addJMSSessionStats(Stats stats) {
        this.resource.addJMSSessionStats(stats);
    }

    public void removeJMSSessionStats(Stats stats) {
        this.resource.removeJMSSessionStats(stats);
    }

    public void addJMSConsumerStats(Stats stats) {
        this.resource.addJMSConsumerStats(stats);
    }

    public void removeJMSConsumerStats(Stats stats) {
        this.resource.removeJMSConsumerStats(stats);
    }

    private AdminMessage startConnection(AdminMessage message) {
        this.started.commit(false, true);
        return message;
    }

    private AdminMessage stopConnection(AdminMessage message) {
        this.started.commit(true, false);
        return message;
    }

    private AdminMessage closeConnection(AdminMessage message) {
        this.close();
        return message;
    }

    private AdminMessage setClientID(SetClientIDMessage message) throws JMSException {
        String newClientID = message.getClientID();
        ConnectionManager.updateClientID(this.clientID, newClientID, this.entry);
        this.clientID = newClientID;
        return message;
    }

    private AdminMessage createSession(CreateSessionMessage create) throws JMSException {
        int sessionID = create.isRecovered() ? create.getSessionID() : this.sequence.getNextValue();
        JMSSession session = new JMSSession(this, sessionID, create.getAckMode());
        this.addSession(sessionID, session);
        create.setAllocatedSessionID(sessionID);
        create.setTargetID((byte)15);
        return create;
    }

    private AdminMessage createDurableConnectionConsumer(CreateConsumerMessage cdt) throws JMSException {
        String durableName = cdt.getDurableName();
        boolean existing = SubscriptionUtil.checkDurableSubscription(this.clientID, durableName);
        String destName = cdt.getDestinationName();
        TopicManager destManager = DestinationUtil.getLocalTopicManager(destName);
        AbstractSubscriptionManager manager = null;
        try {
            String selector = cdt.getSelector();
            boolean noLocal = cdt.getNoLocal();
            boolean started = cdt.getBooleanFlag();
            manager = SubscriptionUtil.addDurableSubscription(this, destManager, this.clientID, durableName, selector, noLocal, false);
            ((SubscriptionManager)manager).setSuspend(!started);
            int consumerID = cdt.isRecovered() ? cdt.getConsumerID() : this.sequence.getNextValue();
            JMSConnectionConsumer consumer = new JMSConnectionConsumer((SubscriptionManager)manager, this, this.entry.getId(), this.connectionID, consumerID);
            consumer.activate();
            this.addConnectionConsumer(consumerID, consumer);
            cdt.setAllocatedConsumerID(consumerID);
        }
        catch (JMSException ex) {
            if (!existing && manager != null) {
                SubscriptionUtil.removeSubscription(manager.getId());
            }
            throw ex;
        }
        this.connectionConsumerCount.increase();
        AdminMessage reply = MessageUtil.createAdminMessage(cdt.getMetaHeader());
        reply.setTargetID((byte)23);
        return reply;
    }

    private AdminMessage createConnectionConsumer(CreateConsumerMessage cq) throws JMSException {
        String destName = cq.getDestinationName();
        DestinationManager destManager = DestinationUtil.getLocalDestinationManager(destName);
        if (!destManager.receiverRegistable()) {
            throw new JMSException("destination " + destName + " is exceeding consumer limit : " + destManager);
        }
        SubscriptionManager manager = null;
        try {
            String selector = cq.getSelector();
            boolean noLocal = cq.getNoLocal();
            boolean started = cq.getBooleanFlag();
            manager = SubscriptionUtil.addSubscription(this, destManager, selector, noLocal, false);
            manager.setSuspend(!started);
            int consumerID = cq.isRecovered() ? cq.getConsumerID() : this.sequence.getNextValue();
            JMSConnectionConsumer consumer = new JMSConnectionConsumer(manager, this, this.entry.getId(), this.connectionID, consumerID);
            consumer.activate();
            this.addConnectionConsumer(consumerID, consumer);
            cq.setAllocatedConsumerID(consumerID);
        }
        catch (JMSException ex) {
            if (manager != null) {
                manager.shutdown();
            }
            throw ex;
        }
        this.connectionConsumerCount.increase();
        AdminMessage reply = MessageUtil.createAdminMessage(cq.getMetaHeader());
        reply.setTargetID((byte)23);
        return reply;
    }

    private AdminMessage getMessageLifecycle(GetMessageLifecycleMessage gml) throws JMSException {
        byte lifecycle = StorageManager.getCurrentStorage().getMessageLifecycle(gml.getMessageID());
        AdminMessage reply = MessageUtil.createAdminMessage(gml.getMetaHeader());
        reply.setByteFlag(lifecycle);
        return reply;
    }

    private AdminMessage cleanUpQueue(CleanUpQueueMessage cu) throws InvalidDestinationException {
        QueueManager queueManager = DestinationUtil.getLocalQueueManager(cu.getQueueName());
        queueManager.removeAllMessage();
        return MessageUtil.createAdminMessage(cu.getMetaHeader());
    }

    private AdminMessage cleanUpDurableSubscriber(CleanUpDurableSubscriberMessage cd) throws InvalidDestinationException {
        SubscriptionUtil.removeAllMessage(cd.getClientID(), cd.getDurableName());
        return MessageUtil.createAdminMessage(cd.getMetaHeader());
    }

    private AdminMessage getDurableMessageLifecycle(GetDurableMessageLifecycleMessage gdml) throws JMSException {
        byte lifecycle = SubscriptionUtil.getDurableMessageLifecycle(gdml.getClientID(), gdml.getDurableName(), gdml.getMessageID());
        AdminMessage reply = MessageUtil.createAdminMessage(gdml.getMetaHeader());
        reply.setByteFlag(lifecycle);
        return reply;
    }

    public AdminMessage unsubscribe(UnsubscribeMessage um) throws JMSException {
        String durableName = um.getDurableName();
        SubscriptionUtil.unsubscribe(this.clientID, durableName);
        return MessageUtil.createAdminMessage(um.getMetaHeader());
    }

    public void shutdownAll() {
        Collection collection = this.sessions.values();
        JMSSession[] jmsSessions = collection.toArray(new JMSSession[collection.size()]);
        for (int i = 0; i < jmsSessions.length; ++i) {
            JMSSession session = jmsSessions[i];
            session.shutdownAll();
        }
        collection = this.consumers.values();
        JMSConnectionConsumer[] consumers = collection.toArray(new JMSConnectionConsumer[collection.size()]);
        for (int i = 0; i < consumers.length; ++i) {
            JMSConnectionConsumer consumer = consumers[i];
            consumer.shutdown();
        }
        this.clearResource();
    }

    public long getEntryID() {
        return this.entry.getId();
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getDigest() {
        return this.connectionName + "[" + (this.clientID == null ? "---" : this.clientID) + "] " + this.sessions.size() + " session(s), " + this.consumers.size() + " consumer(s)";
    }

    public String toString() {
        return this.connectionName;
    }

    private class SerialExecution
    extends SerialExecutable
    implements MessageHandler {
        private SerialExecution() {
        }

        private MessageHandler findMessageHandler(MessageContainer message) throws JMSException {
            byte targetID = message.getLocalTargetID();
            if (targetID == 23) {
                int consumerID = message.getConsumerID();
                return JMSConnection.this.getConsumer(consumerID);
            }
            return this;
        }

        public void execute(MessageContainer packet) throws JMSException {
            MessageHandler handler = this.findMessageHandler(packet);
            try {
                handler.handleMessage(packet);
            }
            catch (JMSException e) {
                handler.handleException(packet, e);
            }
        }

        public void exception(MessageContainer packet, JMSException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5713_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5713_LEVEL, JeusMessage_JMS5._5713, packet, (Throwable)e);
            }
            this.handleException(packet, e);
        }

        public void failed(MessageContainer packet, Throwable t) {
            block3: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5714_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5714_LEVEL, JeusMessage_JMS5._5714, packet, t);
                }
                JMSException ex = new JMSException("internal error for " + t.toString());
                try {
                    JMSConnection.this.sendFailedReply(packet, ex);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5715_LEVEL)) break block3;
                    LogUtils.log(logger, JeusMessage_JMS5._5715_LEVEL, JeusMessage_JMS5._5715, e);
                }
            }
        }

        public void handleMessage(MessageContainer packet) throws JMSException {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5716_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5716_LEVEL, JeusMessage_JMS5._5716, packet);
            }
            AdminMessage result = this.handleAdminMessage((AdminMessage)packet);
            if (packet.isRequestMessage()) {
                JMSConnection.this.sendReply(result);
            }
        }

        private AdminMessage handleAdminMessage(AdminMessage message) throws JMSException {
            if (message.isPublic()) {
                return this.handlePublicAdminMessage(message);
            }
            switch (message.getOperationID()) {
                case 23: {
                    return JMSConnection.this.setClientID((SetClientIDMessage)message);
                }
                case 4: {
                    return JMSConnection.this.startConnection(message);
                }
                case 5: {
                    return JMSConnection.this.stopConnection(message);
                }
                case 6: {
                    return JMSConnection.this.closeConnection(message);
                }
                case 9: {
                    return JMSConnection.this.createSession((CreateSessionMessage)message);
                }
                case 11: {
                    return JMSConnection.this.createConnectionConsumer((CreateConsumerMessage)message);
                }
                case 12: {
                    return JMSConnection.this.createDurableConnectionConsumer((CreateConsumerMessage)message);
                }
                case 7: {
                    return JMSConnection.this.unsubscribe((UnsubscribeMessage)message);
                }
            }
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
        }

        private AdminMessage handlePublicAdminMessage(AdminMessage message) throws JMSException {
            switch (message.getOperationID()) {
                case -1: {
                    return JMSConnection.this.getMessageLifecycle((GetMessageLifecycleMessage)message);
                }
                case -2: {
                    return JMSConnection.this.cleanUpQueue((CleanUpQueueMessage)message);
                }
                case -3: {
                    return JMSConnection.this.cleanUpDurableSubscriber((CleanUpDurableSubscriberMessage)message);
                }
                case -4: {
                    return JMSConnection.this.getDurableMessageLifecycle((GetDurableMessageLifecycleMessage)message);
                }
            }
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
        }

        public void handleException(MessageContainer packet, JMSException ex) {
            block4: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5717_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5717_LEVEL, JeusMessage_JMS5._5717, (Object)new Object[]{packet, JMSConnection.this}, (Throwable)ex);
                }
                if (packet.isRequestMessage()) {
                    AdminMessage reply = MessageUtil.createAdminMessage(packet.getMetaHeader());
                    reply.setException(ex);
                    try {
                        JMSConnection.this.sendReply(reply);
                    }
                    catch (JMSException e) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5718_LEVEL)) break block4;
                        LogUtils.log(logger, JeusMessage_JMS5._5718_LEVEL, JeusMessage_JMS5._5718, e);
                    }
                }
            }
        }

        public String toString() {
            return JMSConnection.this.connectionName + ".RCV.QUEUE[" + this.size() + "]";
        }
    }
}

