/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.JMSConnection;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSConnectionConsumerResource;

public class JMSConnectionConsumer
extends AbstractConsumer
implements MessageHandler {
    private final JMSConnection connection;

    public JMSConnectionConsumer(SubscriptionManager manager, JMSConnection connection, long entryID, int connectionID, int consumerID) {
        super(manager, entryID, connectionID, consumerID);
        this.connection = connection;
        this.consumerName = connection + ".C" + consumerID;
    }

    public void closeConsumer() {
        this.shutdown();
        this.connection.consumerRemoved(this.consumerID);
    }

    void registerMBean() throws JMSException {
        try {
            this.mbean = JMSConnectionConsumerResource.createMBean(this.consumerName, this.connection.getMbeanObject(), this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.stats = this.mbean.getInitialStats();
    }

    void destroyMBean() {
        super.destroyMBean();
        this.connection.removeJMSConsumerStats((Stats)this.stats);
    }

    void sendData(MessageContainer message) throws JMSException {
        message.setTargetID((byte)23);
        message.setConsumerID(this.consumerID);
        this.connection.sendMessage(message);
    }
}

