/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.io.IOException;
import javax.jms.JMSException;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.comm.FileMessageAssembler;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSLocalClientEntry
extends JMSClientEntry {
    private static final String SAME_VM_ADDR = "localhost";
    private static final int SAME_VM_PORT = -1;
    private JMSServerEntry serverEntry;
    private SerialExecutable writer;
    private SerialExecutable xaWriter;

    public JMSLocalClientEntry(JMSServerEntry serverEntry) throws JMSException {
        super(JMSBroker.getLocalBroker().getFirstChannel());
        this.serverEntry = serverEntry;
        this.init();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6881_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6881_LEVEL, JeusMessage_JMS5._6881, new Long(this.id));
        }
    }

    public void sendData(MessageContainer packet) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6882_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6882_LEVEL, JeusMessage_JMS5._6882, new Object[]{packet, this});
        }
        if (packet.isXAExecutable()) {
            this.executor.execute(this.xaWriter, packet);
        } else {
            this.executor.execute(this.writer, packet);
        }
    }

    public void sendDirect(MessageContainer packet) throws JMSException {
        try {
            this.writer.execute(packet);
        }
        catch (Exception e) {
            throw new JMSException("failed to send for " + e.toString());
        }
    }

    public void recvData(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6883_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6883_LEVEL, JeusMessage_JMS5._6883, new Object[]{packet, this});
        }
        if (packet instanceof ClientMessage) {
            if (packet instanceof FileMessageImpl) {
                try {
                    FileMessageAssembler assembler = new FileMessageAssembler(true);
                    packet = assembler.storeFileMessage((FileMessageImpl)packet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.toString());
                }
            }
            packet = new ServerMessage((ClientMessage)packet);
        }
        super.recvData(packet);
    }

    public void init() throws JMSException {
        super.init();
        this.writer = new ReferenceHandler(this.serverEntry);
        this.xaWriter = new ReferenceHandler(this.serverEntry);
    }

    public void unregisterClientChannel() {
        this.channel.unregisterClientEntry(this);
    }

    public String createName() {
        return "JMSClient-LE" + this.id;
    }

    public boolean isRemote() {
        return false;
    }

    public String getHostName() {
        return SAME_VM_ADDR;
    }

    public int getPort() {
        return -1;
    }

    public void start() {
        this.channel.registerClientEntry(this);
    }

    public void prepareShutdown() {
        block7: {
            block6: {
                if (!this.closed.commit(false, true)) {
                    return;
                }
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6884_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6884_LEVEL, JeusMessage_JMS5._6884, this);
                }
                try {
                    this.writer.startExecution();
                }
                catch (Throwable e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6885_LEVEL)) break block6;
                    LogUtils.log(logger, JeusMessage_JMS5._6885_LEVEL, JeusMessage_JMS5._6885, (Object)new Object[]{this, e.getMessage()}, e);
                }
            }
            try {
                this.xaWriter.startExecution();
            }
            catch (Throwable e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6886_LEVEL)) break block7;
                LogUtils.log(logger, JeusMessage_JMS5._6886_LEVEL, JeusMessage_JMS5._6886, (Object)new Object[]{this, e.getMessage()}, e);
            }
        }
        this.unregisterClientChannel();
    }

    public void shutdown() {
        block6: {
            block5: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6887_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6887_LEVEL, JeusMessage_JMS5._6887, this);
                }
                try {
                    this.prepareShutdown();
                }
                catch (Throwable e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6888_LEVEL)) break block5;
                    LogUtils.log(logger, JeusMessage_JMS5._6888_LEVEL, JeusMessage_JMS5._6888, (Object)new Object[]{this, e.getMessage()}, e);
                }
            }
            try {
                this.clearResource();
            }
            catch (Throwable e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6889_LEVEL)) break block6;
                LogUtils.log(logger, JeusMessage_JMS5._6889_LEVEL, JeusMessage_JMS5._6889, (Object)new Object[]{this, e.getMessage()}, e);
            }
        }
    }

    public class ReferenceHandler
    extends SerialExecutable {
        private JMSBaseEntry peer;

        private ReferenceHandler(JMSBaseEntry channel) {
            this.peer = channel;
        }

        public void execute(MessageContainer data) throws JMSException {
            try {
                this.conveyReference(data);
            }
            catch (Exception e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6890_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6890_LEVEL, JeusMessage_JMS5._6890, (Object)new Object[]{data, e}, (Throwable)e);
                }
                throw JMSExceptionFactory.createJMSException("failed to send message", e);
            }
        }

        public boolean postExecution(MessageContainer packet) {
            if (!packet.isExpired()) {
                packet.messageEvent((byte)4);
            }
            return super.postExecution(packet);
        }

        private void conveyReference(MessageContainer packet) throws IOException {
            if (!packet.isAdminMessage()) {
                ServerMessage message = (ServerMessage)packet;
                if (message.isExpired()) {
                    return;
                }
                packet = message.getClientMessageCopy();
            }
            this.peer.recvData(packet);
        }
    }
}

