/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.comm.IntermediateMessageAssembler;
import jeus.jms.common.comm.MessageFabricator;
import jeus.jms.common.comm.MessageWriter;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.comm.ServerMessageFabricator;
import jeus.net.AcceptorConnectionListener;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSRemoteClientEntry
extends JMSClientEntry
implements JMSRemoteEntry,
AcceptorConnectionListener {
    private String hostName;
    private int port;
    private SocketStream stream;
    private MessageWriter writer;
    private Map assemblers = new HashMap();
    private MessageFabricator fabricator = new ServerMessageFabricator(this);

    public JMSRemoteClientEntry(JMSServiceChannel channel) {
        super(channel);
    }

    public IntermediateMessageAssembler getMessageAssembler(int partialID) {
        return (IntermediateMessageAssembler)this.assemblers.get(new Integer(partialID));
    }

    public void addMessageAssembler(int partialID, IntermediateMessageAssembler assembler) {
        this.assemblers.put(new Integer(partialID), assembler);
    }

    public void removeMessageAssembler(int partialID) {
        this.assemblers.remove(new Integer(partialID));
    }

    public SocketStream getSocketStream() {
        return this.stream;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
    }

    public void connectionClosed(Exception exception) {
        this.connectionClosed(exception, this.stream);
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7281_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7281_LEVEL, JeusMessage_JMS5._7281, this);
        }
        if (this.writer != null) {
            this.writer.connectionClosed();
        }
        this.clearSocketStream();
        this.channel.failedClientChannel(this);
    }

    public void runDelegatedTask(Runnable processor, boolean isReplyPacket, Object message) {
        this.channel.runMessageProcessor(processor);
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) throws Exception {
        byte[] data = (byte[])obj;
        MessageContainer message = this.fabricator.fabricate(data);
        if (message != null) {
            this.recvData(message);
        }
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void connectionEstablished(SocketStream sockStream) {
        block4: {
            try {
                this.stream = sockStream;
                this.setAddress(this.stream);
                this.stream.getSocket().setSoTimeout(this.channel.getConnectionTimeout() * 60 * 1000);
            }
            catch (Exception e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7282_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._7282_LEVEL, JeusMessage_JMS5._7282, sockStream, (Throwable)e);
                }
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7283_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS5._7283_LEVEL, JeusMessage_JMS5._7283, new Object[]{sockStream, e.getMessage()});
            }
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7284_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7284_LEVEL, JeusMessage_JMS5._7284, this);
        }
    }

    public void init() throws JMSException {
        super.init();
        this.writer = this.channel.createMessageWriter(this, this.stream);
        this.writer.startExecution();
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        this.stream.getSocket().setSoTimeout(0);
        this.start();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7285_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7285_LEVEL, JeusMessage_JMS5._7285, this);
        }
    }

    public void start() {
        this.channel.registerRemoteClientEntry(this);
        this.executor.execute(this.writer);
    }

    public void sendData(MessageContainer packet) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7286_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7286_LEVEL, JeusMessage_JMS5._7286, new Object[]{packet, this});
        }
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.enqueue(this.executor, packet);
        }
        catch (Exception e) {
            throw JMSExceptionFactory.createJMSException("failed to send " + packet + " for " + e.getMessage(), e);
        }
    }

    public void sendDirect(MessageContainer packet) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7287_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7287_LEVEL, JeusMessage_JMS5._7287, new Object[]{packet, this});
        }
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.executeDirect(packet);
        }
        catch (Exception e) {
            throw new JMSException("failed to send for " + e.toString());
        }
    }

    public void flushWorks() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
    }

    public boolean isSocketStreamUpdatable() {
        return this.stream == null || this.stream.getCloseState() != 0;
    }

    public void setSocketStream(SocketStream stream) throws IOException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7288_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7288_LEVEL, JeusMessage_JMS5._7288, new Object[]{stream, this});
        }
        if (this.isSocketStreamUpdatable()) {
            this.stream = stream;
            this.setAddress(stream);
            this.writer.setSocketStream(stream);
        }
    }

    private void setAddress(SocketStream stream) {
        this.hostName = stream.getHostName();
        this.port = stream.getPort();
    }

    public void prepareShutdown() {
        block4: {
            if (!this.closed.commit(false, true)) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7289_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7289_LEVEL, JeusMessage_JMS5._7289, this);
            }
            try {
                this.writer.flush();
                this.writer.prepareShutdown();
            }
            catch (Throwable t) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7290_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS5._7290_LEVEL, JeusMessage_JMS5._7290, (Object)new Object[]{this, t.getMessage()}, t);
            }
        }
        this.unregisterClientChannel();
    }

    public void shutdown() {
        block10: {
            block9: {
                block8: {
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7291_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS5._7291_LEVEL, JeusMessage_JMS5._7291, this);
                    }
                    try {
                        this.prepareShutdown();
                    }
                    catch (Throwable e) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7292_LEVEL)) break block8;
                        LogUtils.log(logger, JeusMessage_JMS5._7292_LEVEL, JeusMessage_JMS5._7292, this, e);
                    }
                }
                try {
                    if (this.writer != null) {
                        this.writer.shutdown();
                        this.writer = null;
                    }
                }
                catch (Throwable e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7293_LEVEL)) break block9;
                    LogUtils.log(logger, JeusMessage_JMS5._7293_LEVEL, JeusMessage_JMS5._7293, (Object)new Object[]{this.writer, this, e.getMessage()}, e);
                }
            }
            try {
                this.clearSocketStream();
            }
            catch (Throwable e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7294_LEVEL)) break block10;
                LogUtils.log(logger, JeusMessage_JMS5._7294_LEVEL, JeusMessage_JMS5._7294, (Object)new Object[]{this, e.getMessage()}, e);
            }
        }
        this.clearResource();
    }

    private void clearSocketStream() {
        if (this.stream != null && this.stream.getCloseState() == 0) {
            this.stream.destroy();
        }
        this.stream = null;
    }

    public void unregisterClientChannel() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7295_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7295_LEVEL, JeusMessage_JMS5._7295, new Object[]{this, this.channel});
        }
        this.channel.unregisterRemoteClientEntry(this);
    }

    public boolean useDirectByteBuffer() {
        return this.channel.useDirectByteBuffer();
    }

    public String createName() {
        return "JMSClient-RE" + this.id;
    }

    public boolean isRemote() {
        return true;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAddress() {
        return this.hostName + ":" + this.port;
    }
}

