/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class StaleJMSProducer
implements MessageHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public void handleMessage(MessageContainer packet) throws JMSException {
        if (!packet.isAdminMessage()) {
            ServerMessage message = (ServerMessage)packet;
            if (!message.isLocalMessage()) {
                message.parseJMSHeader();
            }
            if (!message.isServerRouting() && !message.isClientRouting() && !message.isTransacted() && message.isNotifyMessage()) {
                DestinationIdentity destination = message.getDestination();
                DestinationManager manager = DestinationUtil.getDestinationManager(destination);
                manager.produce(message);
            }
        }
    }

    public void handleException(MessageContainer packet, JMSException e) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5911_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5911_LEVEL, JeusMessage_JMS5._5911, packet, (Throwable)e);
        }
        if (!packet.isAdminMessage() && e instanceof InvalidDestinationException) {
            DestinationManager manager = DestinationUtil.getDeadLetterQueue();
            manager.enqueue((ServerMessage)packet);
        }
    }
}

