/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import java.io.IOException;
import java.net.SocketException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.CreateEntryMessage;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.JMSRelayClientEntry;
import jeus.jms.server.JMSRemoteClientEntry;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.RelayClientManager;
import jeus.net.AcceptorConnectionListener;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.util.concurrent.Sync;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

class JMSRemoteEntryAcceptor
implements AcceptorConnectionListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private JMSServiceChannel channel;
    private SocketStream stream;
    private JMSRemoteEntry entry;

    public JMSRemoteEntryAcceptor(JMSServiceChannel channel) {
        this.channel = channel;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
    }

    public void runDelegatedTask(Runnable processor, boolean isReplyPacket, Object message) {
        if (this.entry != null) {
            this.entry.runDelegatedTask(processor, isReplyPacket, message);
        } else {
            this.channel.runMessageProcessor(processor);
        }
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        if (this.entry != null) {
            return this.entry.getPiggybackData(msgType, sockStream, piggybackedData);
        }
        return null;
    }

    public void writeDone(SocketStream sockStream) {
        if (this.entry != null) {
            this.entry.writeDone(sockStream);
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) throws Exception {
        if (this.entry != null) {
            this.entry.receiveMessage(obj, sockStream, controlInfo);
        }
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (this.entry != null) {
            this.entry.connectionClosed(exception, socketStream);
        }
        this.entry = null;
        this.stream = null;
    }

    public void connectionEstablished(SocketStream sockStream) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5881_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5881_LEVEL, JeusMessage_JMS5._5881, sockStream);
        }
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5882_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5882_LEVEL, JeusMessage_JMS5._5882, sockStream);
        }
        this.stream = sockStream;
        CreateEntryMessage createEntryMessage = (CreateEntryMessage)piggybackedData;
        long id = createEntryMessage.getEntryID();
        if (!createEntryMessage.isXaRecovery()) {
            try {
                Sync lock = JMSBroker.getLocalBroker().getLock().readLock();
                if (!lock.attempt(0L)) {
                    this.sendFailure(packet, id, new JMSException("JMS Server is not prepared yet. Creating new JMSRemoteEntry is not allowed."));
                }
                lock.release();
            }
            catch (InterruptedException e) {
                this.sendFailure(packet, id, JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)e));
            }
        }
        try {
            this.entry = this.createRemoteEntry(packet, createEntryMessage);
            if (this.entry != null && this.entry instanceof AcceptorConnectionListener) {
                ((AcceptorConnectionListener)this.entry).connectionAllowed(sockStream, packet, connectionType, piggybackedData);
            }
        }
        catch (Exception e) {
            if (e instanceof JMSException) {
                if (this.entry != null) {
                    id = this.entry.getId();
                    this.entry.shutdown();
                }
                this.sendFailure(packet, id, (JMSException)((Object)e));
            }
            throw new IOException(e.getMessage());
        }
    }

    private JMSRemoteEntry createRemoteEntry(NetworkControlPacket packet, CreateEntryMessage message) throws Exception {
        byte opcode = message.getOperationID();
        if (opcode == 13) {
            return this.createClientEntry(packet, message);
        }
        if (opcode == 14) {
            return this.createClusterEntry(packet, message);
        }
        throw new ResourceAllocationException("'" + AdminMessage.getAdminMessageName(opcode) + "' is not supported opcode.");
    }

    private JMSClusterEntry createClusterEntry(NetworkControlPacket packet, CreateEntryMessage message) throws Exception {
        String brokerName = message.getBrokerName();
        if (brokerName.equals("JEUS_MQ_SAF_ENGINE")) {
            ClusteredPeer clusteredPeer = RelayClientManager.getClusteredPeer(this.channel, brokerName, this.stream);
            JMSRelayClientEntry entry = this.acquireRelayClientEntry(packet, clusteredPeer);
            return entry;
        }
        ClusteredPeer peer = ClusterManager.getClusterPeer(brokerName);
        JMSClusterEntry clusterEntry = null;
        try {
            if (!peer.accepted()) {
                throw new ResourceAllocationException("This connection should be closed because the opposite accepted connection from this server");
            }
            clusterEntry = this.acquireClusterEntry(packet, peer);
        }
        catch (Exception e) {
            if (clusterEntry != null) {
                clusterEntry.shutdownAll();
            }
            peer.acceptFailed();
            throw e;
        }
        peer.acceptSuccess();
        return clusterEntry;
    }

    private JMSRemoteClientEntry createClientEntry(NetworkControlPacket packet, CreateEntryMessage message) throws Exception {
        short brokerID = message.getBrokerID();
        long requestID = brokerID == ClusterManager.LOCAL_BROKER_ID ? message.getRequestID() : -1L;
        JMSRemoteClientEntry entry = this.acquireClientEntry(packet, requestID, message.getIntegerFlag());
        return entry;
    }

    private JMSRemoteClientEntry acquireClientEntry(NetworkControlPacket packet, long requestID, int transfer) throws Exception {
        JMSRemoteClientEntry entry;
        if (requestID == -1L) {
            JMSRemoteClientEntry entry2 = this.createClientEntry(this.stream, transfer);
            this.sendReply(packet, entry2.getId(), false);
            return entry2;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5883_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5883_LEVEL, JeusMessage_JMS5._5883, new Long(requestID));
        }
        if ((entry = this.channel.findRemoteClientEntry(requestID)) != null && entry.isSocketStreamUpdatable()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5884_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5884_LEVEL, JeusMessage_JMS5._5884, new Object[]{new Long(requestID), entry});
            }
            this.channel.cancelClientChannel(entry);
            entry.setSocketStream(this.stream);
            this.sendReply(packet, requestID, true);
        } else {
            entry = this.createClientEntry(this.stream, transfer);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5885_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5885_LEVEL, JeusMessage_JMS5._5885, new Object[]{new Long(requestID), entry});
            }
            this.sendReply(packet, entry.getId(), false);
        }
        return entry;
    }

    private JMSRelayClientEntry acquireRelayClientEntry(NetworkControlPacket packet, ClusteredPeer clusteredPeer) throws Exception {
        JMSRelayClientEntry entry = this.createRelayClientEntry(clusteredPeer);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5886_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5886_LEVEL, JeusMessage_JMS5._5886, new Object[]{clusteredPeer.getBrokerName(), entry});
        }
        this.sendReply(packet, entry.getId(), false);
        return entry;
    }

    private JMSClusterEntry acquireClusterEntry(NetworkControlPacket packet, ClusteredPeer peer) throws Exception {
        JMSClusterEntry entry = this.createClusterEntry(peer);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5887_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5887_LEVEL, JeusMessage_JMS5._5887, new Object[]{peer.getBrokerName(), entry});
        }
        this.sendReply(packet, entry.getId(), false);
        return entry;
    }

    private void sendReply(NetworkControlPacket packet, long entryID, boolean recovered) throws IOException {
        AdminMessage reply = MessageUtil.createEstablishAckMessage(ClusterManager.LOCAL_BROKER_NAME, entryID);
        reply.setBrokerID(ClusterManager.LOCAL_BROKER_ID);
        reply.setBooleanFlag(recovered);
        packet.setData((Object)reply);
        this.stream.write((Object)packet);
    }

    private void sendFailure(NetworkControlPacket packet, long entryID, JMSException ex) throws IOException {
        AdminMessage reply = MessageUtil.createEstablishNackMessage(ClusterManager.LOCAL_BROKER_NAME, entryID);
        reply.setException(ex);
        packet.setData((Object)reply);
        this.stream.write((Object)packet);
    }

    private JMSRemoteClientEntry createClientEntry(SocketStream stream, int transfer) throws Exception {
        this.channel.checkAvailable();
        JMSRemoteClientEntry entry = new JMSRemoteClientEntry(this.channel);
        entry.connectionEstablished(stream);
        entry.init();
        return entry;
    }

    private JMSRelayClientEntry createRelayClientEntry(ClusteredPeer clusteredPeer) throws Exception {
        JMSRelayClientEntry entry = new JMSRelayClientEntry(this.channel, clusteredPeer, this.stream);
        entry.connectionEstablished(this.stream);
        return entry;
    }

    private JMSClusterEntry createClusterEntry(ClusteredPeer peer) throws Exception {
        JMSClusterEntry entry = new JMSClusterEntry(this.channel, peer, this.stream);
        entry.connectionEstablished(this.stream);
        return entry;
    }
}

