/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.InvalidSelectorException;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.selector.MessageCheck;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.MessageSink;
import jeus.jms.server.manager.SubscriptionContext;

public abstract class AbstractSubscriptionManager
implements MessageSink {
    public static final int LOCAL_SUBSCRIPTIONS = -1;
    private String selector;
    private MessageCheck msgCheck;
    protected boolean topic;
    protected boolean cluster;
    protected String subscriberName;
    protected final DestinationManager destination;
    protected final String destName;
    protected long id;
    private int weight = 1;
    private int loaded;
    protected SubscriptionContext subscriptionContext;

    protected AbstractSubscriptionManager(SubscriptionContext subscriptionContext, long id, DestinationManager destination, boolean cluster) {
        this.subscriptionContext = subscriptionContext;
        this.id = id;
        this.destination = destination;
        this.cluster = cluster;
        this.destName = destination.getDestinationName();
    }

    public boolean isDurableSubscription() {
        return false;
    }

    public void setSubscriptionContext(SubscriptionContext subscriptionContext) {
        this.subscriptionContext = subscriptionContext;
    }

    public boolean isSelectedMessage(UserMessage message) {
        return this.msgCheck == null || this.msgCheck.isSelectedMessage(message);
    }

    public long getId() {
        return this.id;
    }

    public boolean isGroupManager() {
        return this.id == -1L;
    }

    public void setInitialWeight(int weight) {
        this.weight = weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void increaseLoaded() {
        ++this.loaded;
    }

    public boolean checkLoadable() {
        boolean loadable;
        boolean bl = loadable = this.loaded < this.weight;
        if (!loadable) {
            this.resetLoaded();
        }
        return loadable;
    }

    public void resetLoaded() {
        this.loaded = 0;
    }

    public String getDestinationName() {
        return this.destName;
    }

    public final String getSelector() {
        return this.selector;
    }

    void setSelector(String selector) throws InvalidSelectorException {
        this.msgCheck = selector == null ? null : new MessageCheck(selector);
        this.selector = selector;
    }

    void updateSelector(String selector) throws InvalidSelectorException {
        if (this.selector == null || !this.selector.equals(selector)) {
            this.setSelector(selector);
        }
    }

    public abstract void shutdown();

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSubscriptionManager)) {
            return false;
        }
        AbstractSubscriptionManager another = (AbstractSubscriptionManager)obj;
        return this.id == another.id;
    }
}

