/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import com.sun.naming.internal.ResourceManager;
import java.util.HashSet;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import jeus.jms.server.JMSServer;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class AdministeredObjectBinder {
    private static DirContext ctx;
    protected static final JeusLogger logger;

    public static void init() throws NamingException {
        if (JMSServer.isStandalone()) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("jeus.jndi.jns.forcedbindings", String.valueOf(true));
        properties = ResourceManager.getInitialEnvironment(properties);
        ctx = (DirContext)NamingManager.getInitialContext(properties);
    }

    public static synchronized Object lookup(String exportName) {
        if (JMSServer.isStandalone()) {
            return null;
        }
        try {
            return ctx.lookup(exportName);
        }
        catch (NamingException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6571_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6571_LEVEL, JeusMessage_JMS5._6571, exportName, (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isAlreadyBound(String exportName) {
        try {
            NamingEnumeration<NameClassPair> pair = ctx.list(exportName);
            return pair.hasMore();
        }
        catch (NamingException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6592_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6592_LEVEL, JeusMessage_JMS5._6592, exportName, (Throwable)e);
            }
            return false;
        }
    }

    public static synchronized void rebind(String name, Object obj) throws JMSException {
        if (JMSServer.isStandalone()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6572_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6572_LEVEL, JeusMessage_JMS5._6572, new Object[]{name, obj});
        }
        try {
            ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(false));
            ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(false));
            ctx.addToEnvironment("jeus.jndi.enable.cache", String.valueOf(true));
            ctx.rebind(name, obj);
        }
        catch (NamingException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6573_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6573_LEVEL, JeusMessage_JMS5._6573, (Object)new Object[]{name, obj}, (Throwable)e);
            }
            throw new ResourceAllocationException("failed to rebind " + name);
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6574_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6574_LEVEL, JeusMessage_JMS5._6574, new Object[]{name, obj});
        }
    }

    public static synchronized void bind(String name, Object obj) throws JMSException {
        if (JMSServer.isStandalone()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6575_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6575_LEVEL, JeusMessage_JMS5._6575, new Object[]{name, obj});
        }
        try {
            ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(false));
            ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(false));
            ctx.addToEnvironment("jeus.jndi.enable.cache", String.valueOf(true));
            ctx.bind(name, obj);
        }
        catch (NamingException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6576_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6576_LEVEL, JeusMessage_JMS5._6576, (Object)new Object[]{name, obj}, (Throwable)e);
            }
            throw new ResourceAllocationException("failed to bind " + name);
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6577_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6577_LEVEL, JeusMessage_JMS5._6577, new Object[]{name, obj});
        }
    }

    public static synchronized void rebind(String name, Object obj, HashSet addresses) throws JMSException {
        if (JMSServer.isStandalone()) {
            return;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6578_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6578_LEVEL, JeusMessage_JMS5._6578, new Object[]{name, obj, addresses});
        }
        BasicAttributes attrs = new BasicAttributes("JMS_BROKER_ADDRESS", addresses);
        try {
            ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(true));
            ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(true));
            ctx.addToEnvironment("jeus.jndi.enable.cache", String.valueOf(false));
            ctx.rebind(name, obj, (Attributes)attrs);
        }
        catch (NamingException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6579_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6579_LEVEL, JeusMessage_JMS5._6579, (Object)new Object[]{name, obj, addresses}, (Throwable)e);
            }
            ResourceAllocationException ex = new ResourceAllocationException("failed to rebind " + name);
            throw ex;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6580_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6580_LEVEL, JeusMessage_JMS5._6580, new Object[]{name, obj, addresses});
        }
    }

    public static synchronized void unbind(String name) throws JMSException {
        block5: {
            if (JMSServer.isStandalone()) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6581_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6581_LEVEL, JeusMessage_JMS5._6581, name);
            }
            try {
                ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(false));
                ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(false));
                ctx.unbind(name);
            }
            catch (NamingException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6582_LEVEL)) break block5;
                LogUtils.log(logger, JeusMessage_JMS5._6582_LEVEL, JeusMessage_JMS5._6582, name, (Throwable)e);
            }
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6583_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6583_LEVEL, JeusMessage_JMS5._6583, name);
        }
    }

    public static synchronized void unbind(String name, HashSet addresses) throws JMSException {
        block5: {
            if (JMSServer.isStandalone()) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6584_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6584_LEVEL, JeusMessage_JMS5._6584, new Object[]{name, addresses});
            }
            BasicAttributes attrs = new BasicAttributes("JMS_BROKER_ADDRESS", addresses);
            try {
                ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(true));
                ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(true));
                ctx.modifyAttributes(name, 3, (Attributes)attrs);
            }
            catch (NamingException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6585_LEVEL)) break block5;
                LogUtils.log(logger, JeusMessage_JMS5._6585_LEVEL, JeusMessage_JMS5._6585, (Object)new Object[]{name, addresses}, (Throwable)e);
            }
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6586_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6586_LEVEL, JeusMessage_JMS5._6586, new Object[]{name, addresses});
        }
    }

    public static synchronized void unbindForced(String name) {
        block4: {
            if (JMSServer.isStandalone()) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6587_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6587_LEVEL, JeusMessage_JMS5._6587, name);
            }
            try {
                ctx.unbind(name);
            }
            catch (NamingException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6588_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS5._6588_LEVEL, JeusMessage_JMS5._6588, name, (Throwable)e);
            }
        }
    }

    public static synchronized void unbindGracefully(String name) {
        block5: {
            if (JMSServer.isStandalone()) {
                return;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6589_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6589_LEVEL, JeusMessage_JMS5._6589, name);
            }
            try {
                ctx.addToEnvironment("jeus.jndi.jns.clusterbindings", String.valueOf(false));
                ctx.addToEnvironment("jeus.jndi.jns.replicatebindings", String.valueOf(false));
                ctx.unbind(name);
            }
            catch (NamingException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6590_LEVEL)) break block5;
                LogUtils.log(logger, JeusMessage_JMS5._6590_LEVEL, JeusMessage_JMS5._6590, name, (Throwable)e);
            }
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6591_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6591_LEVEL, JeusMessage_JMS5._6591, name);
        }
    }

    public static void shutdown() {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

