/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.server.comm.ClusterPeerInfo;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.util.JaxbUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.JmsServerClusterType;
import jeus.xml.binding.jeusDD.JmsServerInfoType;
import jeus.xml.binding.jeusDD.QueueClusterType;
import jeus.xml.binding.jeusDD.TopicClusterType;

public class ClusterManager {
    public static String LOCAL_BROKER_NAME;
    public static short LOCAL_BROKER_ID;
    private static JMSServiceChannel channel;
    private static ClusteredPeer local;
    private static HashMap clusteres;
    private static HashMap queueConfigs;
    private static HashMap topicConfigs;
    protected static final JeusLogger logger;

    public static void start() {
        if (clusteres == null) {
            return;
        }
        for (ClusteredPeer peer : clusteres.values()) {
            if (peer.getBrokerID() == LOCAL_BROKER_ID) continue;
            peer.start();
        }
    }

    public static void initClusteredBroker(JmsServerClusterType descriptor) throws JMSException {
        clusteres = new HashMap(3);
        JMSBroker broker = JMSBroker.getLocalBroker();
        channel = descriptor.isSetClusterService() ? broker.getServiceChannel(descriptor.getClusterService()) : broker.getFirstChannel();
        List list = descriptor.getJmsServerInfo();
        for (JmsServerInfoType peerType : list) {
            short peerBrokerID = peerType.getBrokerId();
            String peerBrokerName = peerType.getBrokerName();
            int peerServiceChannelPort = JaxbUtil.getWithDefault(peerType.getJmsPort(), 0);
            String peerServiceChannelHostName = peerType.getIpAddress();
            String virtualID = null;
            virtualID = JaxbUtil.getWithDefault(peerType.isOneport(), peerType.getDefaultOneport()) ? JMSServiceChannelAddress.createVirtualID(peerBrokerName) : null;
            int peerWeight = JaxbUtil.getWithDefault(peerType.getWeight(), peerType.getDefaultWeight());
            int connectionInterval = JaxbUtil.getWithDefault(peerType.getConnectionInterval(), peerType.getDefaultConnectionInterval());
            ClusteredPeer peer = new ClusteredPeer(channel, peerBrokerID, peerBrokerName, peerServiceChannelHostName, peerServiceChannelPort, virtualID, connectionInterval, peerWeight, peerType.getSslConfiguration());
            if (LOCAL_BROKER_NAME.equals(peerBrokerName)) {
                local = peer;
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6271_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6271_LEVEL, JeusMessage_JMS5._6271, peer);
            }
            ClusterManager.addClusterPeer(peerBrokerName, peer);
        }
        if (local == null) {
            throw new JMSException("local descriptor information is missing");
        }
        LOCAL_BROKER_ID = local.getBrokerID();
        Map channelMap = JMSBroker.getLocalBroker().getServiceChannels();
        JMSServiceChannel[] channels = channelMap.values().toArray(new JMSServiceChannel[0]);
        for (int i = 0; i < channels.length; ++i) {
            channels[i].getServiceChannelAddress().setBrokerID(LOCAL_BROKER_ID);
        }
    }

    public static void initClusterConfig(List queue, List topic) {
        for (QueueClusterType qconf : queue) {
            queueConfigs.put(qconf.getQueueClusterName(), qconf);
        }
        for (TopicClusterType tconf : topic) {
            topicConfigs.put(tconf.getTopicClusterName(), tconf);
        }
    }

    public static synchronized void addClusterPeer(String name, ClusteredPeer peer) throws JMSException {
        if (clusteres.containsKey(name)) {
            throw new JMSException("invalid cluster configuration");
        }
        clusteres.put(name, peer);
    }

    public static synchronized void removeClusterPeer(String name) {
        clusteres.remove(name);
    }

    public static synchronized ClusteredPeer findClusterPeer(String peerName) {
        return clusteres == null ? null : (ClusteredPeer)clusteres.get(peerName);
    }

    public static ClusteredPeer getClusterPeer(String peerName) throws JMSException {
        ClusteredPeer peer = ClusterManager.findClusterPeer(peerName);
        if (peer == null) {
            throw new JMSException("invalid peer name [" + peerName + "]");
        }
        return peer;
    }

    public static QueueClusterType getQueueClusterPeers(String qconfName) throws JMSException {
        QueueClusterType queueType = (QueueClusterType)queueConfigs.get(qconfName);
        if (queueType == null) {
            throw new JMSException("invalid queue cluster policy [" + qconfName + "]");
        }
        return queueType;
    }

    public static TopicClusterType getTopicClusterPeers(String tconfName) throws JMSException {
        TopicClusterType topicType = (TopicClusterType)topicConfigs.get(tconfName);
        if (topicType == null) {
            throw new JMSException("invalid topic cluster policy [" + tconfName + "]");
        }
        return topicType;
    }

    public static int getLocalWeight() {
        return local == null ? 1 : local.getWeight();
    }

    public static JMSServiceChannelAddress getClusteringAddress() throws JMSException {
        return channel.getServiceChannelAddress();
    }

    public static ArrayList getClusteredPeers() {
        if (clusteres == null) {
            return new ArrayList();
        }
        ArrayList<ClusteredPeer> list = new ArrayList<ClusteredPeer>();
        for (ClusteredPeer peer : clusteres.values()) {
            list.add(peer);
        }
        return list;
    }

    public static ArrayList getClusteredPeersInfo() {
        ArrayList<ClusterPeerInfo> infos = new ArrayList<ClusterPeerInfo>();
        for (ClusteredPeer peer : ClusterManager.getClusteredPeers()) {
            infos.add(peer.getClusterInfo());
        }
        return infos;
    }

    public static HashSet getClueteredPeersAddresses() {
        HashSet<JMSServiceChannelAddress> addrset = new HashSet<JMSServiceChannelAddress>();
        for (ClusteredPeer peer : ClusterManager.getClusteredPeers()) {
            addrset.add(peer.getAddress());
        }
        return addrset;
    }

    static {
        queueConfigs = new HashMap(3);
        topicConfigs = new HashMap(3);
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

